/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.kerberos.authentication.sun;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.kerberos.authentication.JaasSubjectHolder;
import org.springframework.security.kerberos.authentication.KerberosClient;
import org.springframework.security.kerberos.authentication.sun.JaasUtil;

public class SunJaasKerberosClient
implements KerberosClient {
    private boolean debug = false;
    private boolean multiTier = false;
    private static final Log LOG = LogFactory.getLog(SunJaasKerberosClient.class);

    @Override
    public JaasSubjectHolder login(String username, String password) {
        JaasSubjectHolder result;
        LOG.debug((Object)("Trying to authenticate " + username + " with Kerberos"));
        try {
            LoginContext loginContext = new LoginContext("", null, new KerberosClientCallbackHandler(username, password), new LoginConfig(this.debug));
            loginContext.login();
            Subject jaasSubject = loginContext.getSubject();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Kerberos authenticated user: " + jaasSubject));
            }
            String validatedUsername = jaasSubject.getPrincipals().iterator().next().toString();
            Subject subjectCopy = JaasUtil.copySubject(jaasSubject);
            result = new JaasSubjectHolder(subjectCopy, validatedUsername);
            if (!this.multiTier) {
                loginContext.logout();
            }
        }
        catch (LoginException e) {
            throw new BadCredentialsException("Kerberos authentication failed", (Throwable)e);
        }
        return result;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMultiTier(boolean multiTier) {
        this.multiTier = multiTier;
    }

    private static class KerberosClientCallbackHandler
    implements CallbackHandler {
        private String username;
        private String password;

        public KerberosClientCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)callback;
                    ncb.setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pwcb = (PasswordCallback)callback;
                    pwcb.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "We got a " + callback.getClass().getCanonicalName() + ", but only NameCallback and PasswordCallback is supported");
            }
        }
    }

    private static class LoginConfig
    extends Configuration {
        private boolean debug;

        public LoginConfig(boolean debug) {
            this.debug = debug;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("storeKey", "true");
            if (this.debug) {
                options.put("debug", "true");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
    }
}

