/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.planner;

import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.planner.Planner;
import com.xebialabs.xlrelease.planner.PlannerLink;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem;
import com.xebialabs.xlrelease.planner.PlannerReleaseItem$;
import com.xebialabs.xlrelease.planner.PlannerReleaseTree;
import com.xebialabs.xlrelease.planner.PlannerReleaseTree$;
import com.xebialabs.xlrelease.planner.Plans;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class Planner$ {
    public static final Planner$ MODULE$ = new Planner$();
    private static final int MANUAL_TASK_DURATION = 60;
    private static final int AUTOMATED_TASK_DURATION = 1;
    private static final boolean FROM_END_TO_START = false;
    private static final Function1<PlannerReleaseItem, Object> ALWAYS_USE_SCHEDULED_DATES = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Planner$.$anonfun$ALWAYS_USE_SCHEDULED_DATES$1(x$1));

    public int MANUAL_TASK_DURATION() {
        return MANUAL_TASK_DURATION;
    }

    public int AUTOMATED_TASK_DURATION() {
        return AUTOMATED_TASK_DURATION;
    }

    public boolean FROM_END_TO_START() {
        return FROM_END_TO_START;
    }

    public Function1<PlannerReleaseItem, Object> ALWAYS_USE_SCHEDULED_DATES() {
        return ALWAYS_USE_SCHEDULED_DATES;
    }

    public Option<Plans.Computed> makePlan(PlanItem planItem, DateTime now) {
        return this.makePlan(PlannerReleaseTree$.MODULE$.apply(PlannerReleaseItem$.MODULE$.transform(planItem)), now, this.ALWAYS_USE_SCHEDULED_DATES());
    }

    public Option<Plans.Computed> makePlan(PlannerReleaseTree releaseTree) {
        return this.makePlan(releaseTree, DateTime.now());
    }

    public Option<Plans.Computed> makePlan(PlannerReleaseTree releaseTree, DateTime now) {
        return this.makePlan(releaseTree, now, this.ALWAYS_USE_SCHEDULED_DATES());
    }

    public Option<Plans.Computed> makePlan(PlannerReleaseTree releaseTree, DateTime now, Function1<PlannerReleaseItem, Object> useScheduledDates) {
        return new Planner.MakePlan(releaseTree, now, useScheduledDates).apply();
    }

    public DateTime makePlan$default$2() {
        return DateTime.now();
    }

    public DateTime computeStartDate(PlannerReleaseItem item, DateTime proposedStartDate, boolean useScheduledDates) {
        return this.startOfMinute((DateTime)item.startDate().orElse((Function0 & Serializable)() -> {
            if (useScheduledDates) {
                return item.scheduledStartDate();
            }
            return None$.MODULE$;
        }).orElse((Function0 & Serializable)() -> {
            if (useScheduledDates) {
                return item.dueDate().flatMap((Function1 & Serializable)dueDate -> item.plannedDuration().map((Function1 & Serializable)duration -> dueDate.minus((ReadableDuration)duration)));
            }
            return None$.MODULE$;
        }).getOrElse((Function0 & Serializable)() -> proposedStartDate));
    }

    public DateTime computeEndDate(PlannerReleaseItem item, DateTime proposedDate, DateTime displayStartDate, DateTime now, boolean useScheduledDates) {
        DateTime endDate = (DateTime)item.endDate().orElse((Function0 & Serializable)() -> {
            if (useScheduledDates) {
                return item.dueDate();
            }
            return None$.MODULE$;
        }).orElse((Function0 & Serializable)() -> {
            if (useScheduledDates) {
                return item.plannedDuration().map((Function1 & Serializable)plannedDuration -> displayStartDate.plus((ReadableDuration)plannedDuration));
            }
            return None$.MODULE$;
        }).orElse((Function0 & Serializable)() -> {
            if (item.isAutomatedTask()) {
                return new Some((Object)proposedDate.plusMinutes(MODULE$.AUTOMATED_TASK_DURATION()));
            }
            return None$.MODULE$;
        }).orElse((Function0 & Serializable)() -> {
            if (item.isManualTask() && !item.isDependentTask()) {
                return new Some((Object)proposedDate.plusMinutes(MODULE$.MANUAL_TASK_DURATION()));
            }
            return None$.MODULE$;
        }).getOrElse((Function0 & Serializable)() -> proposedDate);
        DateTime endDate1 = this.latest(displayStartDate, endDate);
        DateTime endDate2 = item.isActiveLeafTask() ? this.latest(now, endDate1) : endDate1;
        return this.startOfMinute(endDate2);
    }

    public DateTime startOfMinute(DateTime dt) {
        return dt.withSecondOfMinute(0).withMillisOfSecond(0);
    }

    public DateTime latest(DateTime a, DateTime b) {
        if (a.isAfter((ReadableInstant)b)) {
            return a;
        }
        return b;
    }

    public DateTime findMaxDate(DateTime dateTime, List<DateTime> dates) {
        return (DateTime)dates.foldLeft((Object)dateTime, (Function2 & Serializable)(a, b) -> MODULE$.latest((DateTime)a, (DateTime)b));
    }

    public Set<String> findPredecessorsIds(List<PlannerLink> links, String itemId) {
        return this.findPredecessorsIds0(links, itemId, (List<String>)package$.MODULE$.List().empty(), (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public Set<String> findPredecessorsIds0(List<PlannerLink> links, String itemId, List<String> toProcess, Set<String> found) {
        List list;
        while (true) {
            List nextIds;
            if (Nil$.MODULE$.equals(list = (List)toProcess.$plus$plus((IterableOnce)(nextIds = links.filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)Planner$.$anonfun$findPredecessorsIds0$1(itemId, x$14))).map((Function1 & Serializable)x$15 -> x$15.source().id()))))) {
                return found;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            String nextId = (String)colon2.head();
            List rest = colon2.next$access$1();
            found = (Set)found.$plus$plus((IterableOnce)nextIds);
            toProcess = (List)toProcess.$plus$plus((IterableOnce)rest);
            itemId = nextId;
        }
        throw new MatchError((Object)list);
    }

    public List<Option<PlannerReleaseItem>> mapIdsToItems(List<String> ids, List<PlannerReleaseItem> items) {
        return ids.map((Function1 & Serializable)id -> items.find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)Planner$.$anonfun$mapIdsToItems$2(id, x$16))));
    }

    public static final /* synthetic */ boolean $anonfun$ALWAYS_USE_SCHEDULED_DATES$1(PlannerReleaseItem x$1) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$findPredecessorsIds0$1(String itemId$1, PlannerLink x$14) {
        String string = x$14.target().id();
        String string2 = itemId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mapIdsToItems$2(String id$1, PlannerReleaseItem x$16) {
        String string = x$16.id();
        String string2 = id$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private Planner$() {
    }
}

