/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.apiclient.services;

import com.versionone.apiclient.services.TextBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BuildResult {
    private final HashMap<String, String> queryParameters = new LinkedHashMap<String, String>();
    public final List<String> pathParts = new ArrayList<String>();

    public void addQueryParameter(String name, String value) {
        this.queryParameters.put(name, value);
    }

    public int getQueryParameterCount() {
        return this.queryParameters.size();
    }

    public String urlEncode(String valueString) {
        try {
            valueString = URLEncoder.encode(valueString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            valueString = valueString.replace("+", "%2B");
            valueString = valueString.replace(" ", "+");
            valueString = valueString.replace("&", "%26");
            valueString = valueString.replace("#", "%23");
        }
        return valueString;
    }

    public String toUrl() {
        ArrayList<String> encodedPathParts = new ArrayList<String>();
        for (String pathPart : this.pathParts) {
            encodedPathParts.add(this.urlEncode(pathPart));
        }
        String path = TextBuilder.join(encodedPathParts, "/");
        ArrayList<String> queryParts = new ArrayList<String>();
        for (Map.Entry<String, String> queryParameter : this.queryParameters.entrySet()) {
            queryParts.add(String.format("%s=%s", queryParameter.getKey(), this.urlEncode(queryParameter.getValue())));
        }
        String querystring = TextBuilder.join(queryParts, "&");
        String result = path.concat(querystring != null ? "?" + querystring : "");
        return result;
    }
}

