/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.vfs2.util.OsFamily;

@Deprecated
public final class Os {
    public static final OsFamily OS_FAMILY_WINDOWS = new OsFamily("windows");
    public static final OsFamily OS_FAMILY_DOS = new OsFamily("dos");
    public static final OsFamily OS_FAMILY_WINNT = new OsFamily("nt", new OsFamily[]{OS_FAMILY_WINDOWS});
    public static final OsFamily OS_FAMILY_WIN9X = new OsFamily("win9x", new OsFamily[]{OS_FAMILY_WINDOWS, OS_FAMILY_DOS});
    public static final OsFamily OS_FAMILY_OS2 = new OsFamily("os/2", new OsFamily[]{OS_FAMILY_DOS});
    public static final OsFamily OS_FAMILY_NETWARE = new OsFamily("netware");
    public static final OsFamily OS_FAMILY_UNIX = new OsFamily("unix");
    public static final OsFamily OS_FAMILY_MAC = new OsFamily("mac");
    public static final OsFamily OS_FAMILY_OSX = new OsFamily("osx", new OsFamily[]{OS_FAMILY_UNIX, OS_FAMILY_MAC});
    private static final String OS_NAME = SystemProperties.getOsName().toLowerCase(Locale.US);
    private static final String OS_ARCH = SystemProperties.getOsArch().toLowerCase(Locale.US);
    private static final String OS_VERSION = SystemProperties.getOsVersion().toLowerCase(Locale.US);
    private static final String PATH_SEP = File.pathSeparator;
    private static final OsFamily OS_FAMILY;
    private static final OsFamily[] OS_ALL_FAMILIES;
    private static final OsFamily[] ALL_FAMILIES;

    private static boolean archMatches(String arch) {
        boolean isArch = true;
        if (arch != null) {
            isArch = arch.equalsIgnoreCase(OS_ARCH);
        }
        return isArch;
    }

    private static OsFamily[] determineAllFamilies() {
        HashSet<OsFamily> allFamilies = new HashSet<OsFamily>();
        if (OS_FAMILY != null) {
            ArrayList<OsFamily> queue = new ArrayList<OsFamily>();
            queue.add(OS_FAMILY);
            while (!queue.isEmpty()) {
                OsFamily family = (OsFamily)queue.remove(0);
                allFamilies.add(family);
                OsFamily[] families = family.getFamilies();
                Collections.addAll(queue, families);
            }
        }
        return allFamilies.toArray(OsFamily.EMPTY_OS_FAMILY_ARRAY);
    }

    private static OsFamily determineOsFamily() {
        if (OS_NAME.contains("windows")) {
            if (OS_NAME.contains("xp") || OS_NAME.contains("2000") || OS_NAME.contains("nt")) {
                return OS_FAMILY_WINNT;
            }
            return OS_FAMILY_WIN9X;
        }
        if (OS_NAME.contains("os/2")) {
            return OS_FAMILY_OS2;
        }
        if (OS_NAME.contains("netware")) {
            return OS_FAMILY_NETWARE;
        }
        if (OS_NAME.contains("mac")) {
            if (OS_NAME.endsWith("x")) {
                return OS_FAMILY_OSX;
            }
            return OS_FAMILY_MAC;
        }
        if (PATH_SEP.equals(":")) {
            return OS_FAMILY_UNIX;
        }
        return null;
    }

    private static boolean familyMatches(OsFamily family) {
        if (family == null) {
            return false;
        }
        for (OsFamily osFamily : OS_ALL_FAMILIES) {
            if (family != osFamily) continue;
            return true;
        }
        return false;
    }

    public static OsFamily getFamily(String name) {
        for (OsFamily osFamily : ALL_FAMILIES) {
            if (!osFamily.getName().equalsIgnoreCase(name)) continue;
            return osFamily;
        }
        return null;
    }

    public static boolean isArch(String arch) {
        return Os.isOs((OsFamily)null, null, arch, null);
    }

    public static boolean isFamily(OsFamily family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isFamily(String family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return Os.isOs((OsFamily)null, name, null, null);
    }

    public static boolean isOs(OsFamily family, String name, String arch, String version) {
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = Os.familyMatches(family);
            boolean isName = Os.nameMatches(name);
            boolean isArch = Os.archMatches(arch);
            boolean isVersion = Os.versionMatches(version);
            return isFamily && isName && isArch && isVersion;
        }
        return false;
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        return Os.isOs(Os.getFamily(family), name, arch, version);
    }

    public static boolean isVersion(String version) {
        return Os.isOs((OsFamily)null, null, null, version);
    }

    private static boolean nameMatches(String name) {
        boolean isName = true;
        if (name != null) {
            isName = name.equalsIgnoreCase(OS_NAME);
        }
        return isName;
    }

    private static boolean versionMatches(String version) {
        boolean isVersion = true;
        if (version != null) {
            isVersion = version.equalsIgnoreCase(OS_VERSION);
        }
        return isVersion;
    }

    private Os() {
    }

    static {
        ALL_FAMILIES = new OsFamily[]{OS_FAMILY_DOS, OS_FAMILY_MAC, OS_FAMILY_NETWARE, OS_FAMILY_OS2, OS_FAMILY_OSX, OS_FAMILY_UNIX, OS_FAMILY_WINDOWS, OS_FAMILY_WINNT, OS_FAMILY_WIN9X};
        OS_FAMILY = Os.determineOsFamily();
        OS_ALL_FAMILIES = Os.determineAllFamilies();
    }
}

