/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.SignatureService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailAddressService {
    private static final Logger logger = LoggerFactory.getLogger(EmailAddressService.class);
    private final TeamService teamService;
    private final RoleService roleService;
    private final UserProfileService userProfileService;
    private final SignatureService signatureService;

    @Autowired
    public EmailAddressService(TeamService teamService, RoleService roleService, UserProfileService userProfileService, SignatureService signatureService) {
        this.teamService = teamService;
        this.roleService = roleService;
        this.userProfileService = userProfileService;
        this.signatureService = signatureService;
    }

    public Map<String, String> getEmailAddressesFromTask(Task task) {
        HashMap<String, String> assignees = new HashMap<String, String>();
        Optional<String> taskOwner = Optional.ofNullable(task.getOwner()).map(o -> this.replaceVariable((String)o, task.getRelease().getAllStringVariableValues()));
        taskOwner.ifPresent(owner -> this.getNotificationEmailOf((String)owner).ifPresent(s -> assignees.put(this.signatureService.correctCase((String)s), (String)owner)));
        Optional<String> taskTeam = Optional.ofNullable(task.getTeam()).map(o -> this.replaceVariable((String)o, task.getRelease().getAllStringVariableValues()));
        taskTeam.flatMap(t -> this.teamService.findTeamByName(task.getRelease().getId(), t).map(this::getAllMembers)).orElse(Collections.emptySet()).forEach(principal -> this.getNotificationEmailOf((String)principal).ifPresent(email -> assignees.put(this.signatureService.correctCase((String)email), (String)principal)));
        return assignees;
    }

    public boolean emailIsWhitelisted(String fromEmail, ImapServer imapServer) {
        if (imapServer.isWhitelistEnabled()) {
            return imapServer.getWhitelist().stream().map(this.signatureService::correctCase).anyMatch(this.signatureService.correctCase(fromEmail)::endsWith);
        }
        return true;
    }

    private Optional<String> getNotificationEmailOf(String username) {
        return Optional.ofNullable(username).filter(u -> !u.isEmpty()).map(arg_0 -> ((UserProfileService)this.userProfileService).discover(arg_0)).filter(UserProfile::isLoginAllowed).map(UserProfile::getEmail);
    }

    private Set<String> getAllMembers(Team team) {
        List assignments = this.roleService.readRoleAssignments();
        List teamMembers = team.getMembers();
        ArrayList roleMembers = new ArrayList();
        team.getRoles().forEach(roleName -> assignments.stream().filter(a -> a.getName().equals(roleName)).forEach(role -> roleMembers.addAll(role.getPrincipals())));
        HashSet<String> allMembers = new HashSet<String>();
        allMembers.addAll(teamMembers);
        allMembers.addAll(roleMembers);
        return allMembers;
    }

    private String replaceVariable(String key, Map<String, String> variables) {
        if (VariableHelper.containsVariables((String)key)) {
            return VariableHelper.replaceAll((String)key, variables);
        }
        return key;
    }
}

