/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service.generatestrategy;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.api.v1.FolderApi;
import com.xebialabs.xlrelease.ascode.service.AllSearch$;
import com.xebialabs.xlrelease.ascode.service.ExactSearch;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService;
import com.xebialabs.xlrelease.ascode.service.FolderSearch;
import com.xebialabs.xlrelease.ascode.service.GenerateService;
import com.xebialabs.xlrelease.ascode.service.SearchScope;
import com.xebialabs.xlrelease.ascode.service.generatestrategy.CiGenerator$;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.FolderService;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\b\u0010\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u001d)\u0006A1A\u0005\u0002YCaA\u0017\u0001!\u0002\u00139\u0006\"B.\u0001\t\u0003a\u0006bBA\u0005\u0001\u0011%\u00111\u0002\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\t\t\u0004\u0001C\u0005\u0003gAq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002N\u0001!I!a\u0014\u0003\u001f\u0019{G\u000eZ3s\u000f\u0016tWM]1u_JT!\u0001E\t\u0002!\u001d,g.\u001a:bi\u0016\u001cHO]1uK\u001eL(B\u0001\n\u0014\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001F\u000b\u0002\r\u0005\u001c8m\u001c3f\u0015\t1r#A\u0005yYJ,G.Z1tK*\u0011\u0001$G\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AG\u0001\u0004G>l7\u0001A\n\u0003\u0001u\u0001\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0017a\u00054pY\u0012,'/Q:D_\u0012,7+\u001a:wS\u000e,\u0007CA\u0013'\u001b\u0005\t\u0012BA\u0014\u0012\u0005M1u\u000e\u001c3fe\u0006\u001b8i\u001c3f'\u0016\u0014h/[2f\u0003%1w\u000e\u001c3fe\u0006\u0003\u0018\u000e\u0005\u0002+_5\t1F\u0003\u0002-[\u0005\u0011a/\r\u0006\u0003]U\t1!\u00199j\u0013\t\u00014FA\u0005G_2$WM]!qS\u0006iam\u001c7eKJ\u001cVM\u001d<jG\u0016\u0004\"aM\u001b\u000e\u0003QR!AE\u000b\n\u0005Y\"$!\u0004$pY\u0012,'oU3sm&\u001cW-A\u0006qKJl\u0017n]:j_:\u001c\bCA\u001d=\u001b\u0005Q$BA\u001e\u0016\u0003!\u0019XmY;sSRL\u0018BA\u001f;\u0005E\u0001VM]7jgNLwN\\\"iK\u000e\\WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0001\u00135\tR#\u0011\u0005\u0005\u0003Q\"A\b\t\u000b\r*\u0001\u0019\u0001\u0013\t\u000b!*\u0001\u0019A\u0015\t\u000bE*\u0001\u0019\u0001\u001a\t\u000b]*\u0001\u0019\u0001\u001d)\u0005\u00159\u0005C\u0001%T\u001b\u0005I%B\u0001&L\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u00196\u000bqAZ1di>\u0014\u0018P\u0003\u0002O\u001f\u0006)!-Z1og*\u0011\u0001+U\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t!+A\u0002pe\u001eL!\u0001V%\u0003\u0013\u0005+Ho\\<je\u0016$\u0017!\u0006+P)\u0006cuLU#T+2#v\fU#S?B\u000bu)R\u000b\u0002/B\u0011a\u0004W\u0005\u00033~\u0011A\u0001T8oO\u00061Bk\u0014+B\u0019~\u0013ViU+M)~\u0003VIU0Q\u0003\u001e+\u0005%\u0001\u0007hKR4u\u000e\u001c3fe\u000eK7\u000f\u0006\u0002^cB\u0019aLZ5\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u00012\u001c\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002f?\u00059\u0001/Y2lC\u001e,\u0017BA4i\u0005\u0011a\u0015n\u001d;\u000b\u0005\u0015|\u0002C\u00016p\u001b\u0005Y'B\u00017n\u0003\u00191w\u000e\u001c3fe*\u0011a.F\u0001\u0007I>l\u0017-\u001b8\n\u0005A\\'A\u0002$pY\u0012,'\u000fC\u0003s\u0011\u0001\u00071/A\bhK:,'/\u0019;pe\u000e{gNZ5h!\r!\u00181\u0001\b\u0003k~t!A\u001e@\u000f\u0005]lhB\u0001=}\u001d\tI8P\u0004\u0002au&\t!$\u0003\u0002\u00193%\u0011acF\u0005\u0003)UI!AE\n\n\u0007\u0005\u0005\u0011#A\bHK:,'/\u0019;f'\u0016\u0014h/[2f\u0013\u0011\t)!a\u0002\u0003\u001f\u001d+g.\u001a:bi>\u00148i\u001c8gS\u001eT1!!\u0001\u0012\u0003I9W\r\u001e$pY\u0012,'\u000fS5fe\u0006\u00148\r[=\u0015\t\u00055\u00111\u0003\t\u0005=\u0005=\u0011.C\u0002\u0002\u0012}\u0011aa\u00149uS>t\u0007bBA\u000b\u0013\u0001\u0007\u0011qC\u0001\u0003S\u0012\u0004B!!\u0007\u0002\"9!\u00111DA\u000f!\t\u0001w$C\u0002\u0002 }\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u0011aa\u0015;sS:<'bAA\u0010?\u0005\u0019r-\u001a8fe\u0006$XMR8mI\u0016\u0014()_%egR\u0019Q,a\u000b\t\u000f\u00055\"\u00021\u0001\u00020\u0005\u0019\u0011\u000eZ:\u0011\ty3\u0017qC\u0001\u000fO\u0016tWM]1uK\u001a{G\u000eZ3s)\u001di\u0016QGA\u001d\u0003wAq!a\u000e\f\u0001\u0004\t9\"\u0001\u0003qCRD\u0007bBA\u000b\u0017\u0001\u0007\u0011q\u0003\u0005\b\u0003{Y\u0001\u0019AA \u0003EIgn\u00197vI\u0016\u001cVO\u0019$pY\u0012,'o\u001d\t\u0004=\u0005\u0005\u0013bAA\"?\t9!i\\8mK\u0006t\u0017A\u00044jYR,'OV5fo\u0006\u0014G.\u001a\u000b\u0004;\u0006%\u0003BBA&\u0019\u0001\u0007Q,A\u0003ji\u0016l7/\u0001\rf]\u001a|'oY3G_2$WM\u001d)fe6L7o]5p]N$B!a\u0010\u0002R!9\u00111K\u0007A\u0002\u0005]\u0011\u0001\u00034pY\u0012,'/\u00133)\u0007\u0001\t9\u0006\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tifT\u0001\u000bgR,'/Z8usB,\u0017\u0002BA1\u00037\u0012\u0011bQ8na>tWM\u001c;")
public class FolderGenerator {
    private final FolderAsCodeService folderAsCodeService;
    private final FolderService folderService;
    private final PermissionChecker permissions;
    private final long TOTAL_RESULT_PER_PAGE;

    public long TOTAL_RESULT_PER_PAGE() {
        return this.TOTAL_RESULT_PER_PAGE;
    }

    public List<Folder> getFolderCis(GenerateService.GeneratorConfig generatorConfig) {
        SearchScope searchScope = generatorConfig.searchScope();
        if (searchScope instanceof ExactSearch) {
            ExactSearch exactSearch = (ExactSearch)searchScope;
            List<String> ids = exactSearch.ids();
            return this.generateFolderByIds(ids);
        }
        if (searchScope instanceof FolderSearch) {
            FolderSearch folderSearch = (FolderSearch)searchScope;
            String path = folderSearch.path();
            String id = folderSearch.folderId();
            boolean includeSubFolders = folderSearch.includeSubFolders();
            return this.generateFolder(path, id, includeSubFolders);
        }
        if (AllSearch$.MODULE$.equals(searchScope) && generatorConfig.cisConfig().hasFolderTypes()) {
            return CiGenerator$.MODULE$.paginate((Function1 & Serializable)page -> FolderGenerator.$anonfun$getFolderCis$1(this, BoxesRunTime.unboxToLong((Object)page)));
        }
        return package$.MODULE$.List().empty();
    }

    private Option<Folder> getFolderHierarchy(String id) {
        if (Ids.ROOT_FOLDER_ID.equals(id)) {
            return None$.MODULE$;
        }
        String folderId = id;
        Folder root = null;
        boolean enforcePermissions = this.enforceFolderPermissions(id);
        while (!Ids.ROOT_FOLDER_ID.equals(folderId)) {
            Folder leaf = this.folderService.findViewableFoldersById(folderId, Predef$.MODULE$.int2Integer(0), enforcePermissions);
            folderId = folderId.substring(0, folderId.lastIndexOf("/"));
            if (root != null) {
                leaf.setChildren(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Folder[]{root}))).asJava());
            }
            root = leaf;
        }
        return new Some(root);
    }

    private List<Folder> generateFolderByIds(List<String> ids) {
        scala.collection.immutable.Set folders = ids.map((Function1 & Serializable)id -> id.substring(0, id.lastIndexOf("/"))).toSet();
        if (folders.size() > 1) {
            throw new AsCodeException("Cannot generate for specific ids in different folders", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return ((IterableOnceOps)folders.flatMap((Function1 & Serializable)id -> this.getFolderHierarchy((String)id))).toList();
    }

    private List<Folder> generateFolder(String path, String id, boolean includeSubFolders) {
        Failure failure;
        Throwable e;
        Success success;
        Option option;
        Integer depth = includeSubFolders ? Predef$.MODULE$.int2Integer(Integer.MAX_VALUE) : Predef$.MODULE$.int2Integer(0);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> (Option)Option$.MODULE$.apply((Object)id).map((Function1 & Serializable)x$1 -> new Some((Object)$this.folderService.findViewableFoldersById(id, Optional.ofNullable(depth).orElse(Page$.MODULE$.DEFAULT_DEPTH()), this.enforceFolderPermissions(id)))).getOrElse((Function0 & Serializable)() -> $this.folderAsCodeService.searchFolder(path, includeSubFolders, $this.folderAsCodeService.searchFolder$default$3())));
        if (try_ instanceof Success && (option = (Option)(success = (Success)try_).value()) instanceof Some) {
            Folder foundFolder;
            Some some = (Some)option;
            Folder folder = foundFolder = (Folder)some.value();
            return this.filterViewable((List<Folder>)Nil$.MODULE$.$colon$colon((Object)folder));
        }
        if (try_ instanceof Failure && (e = (failure = (Failure)try_).exception()) instanceof PermissionDeniedException) {
            PermissionDeniedException permissionDeniedException = (PermissionDeniedException)e;
            throw permissionDeniedException;
        }
        return Nil$.MODULE$;
    }

    private List<Folder> filterViewable(List<Folder> items) {
        return items.filter((Function1 & Serializable)folder -> BoxesRunTime.boxToBoolean((boolean)FolderGenerator.$anonfun$filterViewable$1(this, folder))).map((Function1 & Serializable)folder -> {
            folder.setChildren(CollectionConverters$.MODULE$.SetHasAsJava((Set)this.filterViewable((List<Folder>)CollectionConverters$.MODULE$.SetHasAsScala(folder.getChildren()).asScala().toList()).toSet()).asJava());
            return folder;
        });
    }

    private boolean enforceFolderPermissions(String folderId) {
        return !this.permissions.isCurrentUserAdmin() && !this.permissions.hasPermission(XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION, folderId);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getFolderCis$1(FolderGenerator $this, long page) {
        List folders = CollectionConverters$.MODULE$.ListHasAsScala($this.folderService.listViewableFolders(Folder.ROOT_FOLDER_ID, Page$.MODULE$.parse(Optional.ofNullable(BoxesRunTime.boxToLong((long)page)), Optional.ofNullable(BoxesRunTime.boxToLong((long)$this.TOTAL_RESULT_PER_PAGE())), Optional.ofNullable(Predef$.MODULE$.int2Integer(Integer.MAX_VALUE))), true, false)).asScala().toList();
        List<Folder> viewableFolders = $this.filterViewable((List<Folder>)folders);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(viewableFolders), (Object)BoxesRunTime.boxToBoolean(((long)viewableFolders.size() < $this.TOTAL_RESULT_PER_PAGE() ? 1 : 0) != 0));
    }

    public static final /* synthetic */ boolean $anonfun$filterViewable$1(FolderGenerator $this, Folder folder) {
        return $this.permissions.hasPermission(XLReleasePermissions.GENERATE_FOLDER_CONFIGURATION, folder.getId()) || $this.permissions.hasPermission(XLReleasePermissions.VIEW_FOLDER, folder.getId());
    }

    @Autowired
    public FolderGenerator(FolderAsCodeService folderAsCodeService, FolderApi folderApi, FolderService folderService, PermissionChecker permissions) {
        this.folderAsCodeService = folderAsCodeService;
        this.folderService = folderService;
        this.permissions = permissions;
        this.TOTAL_RESULT_PER_PAGE = 100L;
    }
}

