/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.ansible;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class JGitClient {
    public static String cloneRepository(String repoUrl, String branch) throws GitAPIException, IllegalArgumentException, IOException {
        String string;
        block10: {
            String uuidString = UUID.randomUUID().toString().replaceAll("-", "");
            String randomDirName = "jgit" + uuidString;
            Path tempDirectory = Files.createTempDirectory(randomDirName, new FileAttribute[0]);
            CloneCommand cloneCommand = Git.cloneRepository().setURI(repoUrl).setDirectory(tempDirectory.toFile());
            if (branch != null && !branch.isEmpty()) {
                cloneCommand.setBranch("refs/heads/" + branch);
            }
            Git result = cloneCommand.call();
            try {
                string = tempDirectory.toString();
                if (result == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    if (Files.exists(tempDirectory, new LinkOption[0])) {
                        JGitClient.deleteDirectory(tempDirectory.toFile());
                    }
                    throw e;
                }
            }
            result.close();
        }
        return string;
    }

    public static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                JGitClient.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public static boolean deleteDirectory(String directoryPath) {
        return JGitClient.deleteDirectory(new File(directoryPath));
    }
}

