/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.actors.kryoserializers.javakaffee.jodatime;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.xebialabs.xlrelease.actors.kryoserializers.javakaffee.jodatime.IdentifiableChronology;
import org.joda.time.Chronology;
import org.joda.time.Interval;

public class JodaIntervalSerializer
extends Serializer<Interval> {
    public JodaIntervalSerializer() {
        this.setImmutable(true);
    }

    public Interval read(Kryo kryo, Input input, Class<? extends Interval> type) {
        long startMillis = input.readLong(true);
        long endMillis = input.readLong(true);
        Chronology chronology = IdentifiableChronology.readChronology(input);
        return new Interval(startMillis, endMillis, chronology);
    }

    public void write(Kryo kryo, Output output, Interval obj) {
        long startMillis = obj.getStartMillis();
        long endMillis = obj.getEndMillis();
        String chronologyId = IdentifiableChronology.getChronologyId(obj.getChronology());
        output.writeLong(startMillis, true);
        output.writeLong(endMillis, true);
        output.writeString(chronologyId == null ? "" : chronologyId);
    }
}

