/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.validators;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.security.dto.PasswordValidationResult;
import com.xebialabs.xlplatform.security.validator.Invalid;
import com.xebialabs.xlplatform.security.validator.StringValidator;
import com.xebialabs.xlplatform.security.validator.Valid;
import com.xebialabs.xlplatform.security.validator.ValidationResult;
import com.xebialabs.xlrelease.api.v1.forms.UserAccount;
import com.xebialabs.xlrelease.domain.validators.UserAccountValidator$;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005Mq!B\u0007\u000f\u0011\u0003Ib!B\u000e\u000f\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003\"B\u0013\u0002\t\u00031c\u0001B\u000e\u000f\u0001]B\u0001\u0002\u000f\u0003\u0003\u0006\u0004%\t!\u000f\u0005\t\t\u0012\u0011\t\u0011)A\u0005u!)1\u0005\u0002C\u0001\u000b\")q\u000b\u0002C\u00011\")\u0001\u000e\u0002C\u0001S\")1\u000e\u0002C\u0001Y\")1\u000e\u0002C\u0001]\")\u0011\u000f\u0002C\u0001e\u0006!Rk]3s\u0003\u000e\u001cw.\u001e8u-\u0006d\u0017\u000eZ1u_JT!a\u0004\t\u0002\u0015Y\fG.\u001b3bi>\u00148O\u0003\u0002\u0012%\u00051Am\\7bS:T!a\u0005\u000b\u0002\u0013ad'/\u001a7fCN,'BA\u000b\u0017\u0003%AXMY5bY\u0006\u00147OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001!\tQ\u0012!D\u0001\u000f\u0005Q)6/\u001a:BG\u000e|WO\u001c;WC2LG-\u0019;peN\u0011\u0011!\b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0012aE5t-\u0006d\u0017\u000eZ#nC&d\u0017\t\u001a3sKN\u001cHCA\u0014+!\tq\u0002&\u0003\u0002*?\t9!i\\8mK\u0006t\u0007\"B\u0016\u0004\u0001\u0004a\u0013!B3nC&d\u0007CA\u00175\u001d\tq#\u0007\u0005\u00020?5\t\u0001G\u0003\u000221\u00051AH]8pizJ!aM\u0010\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003g}\u0019\"\u0001B\u000f\u0002#A\f7o]<pe\u00124\u0016\r\\5eCR|'/F\u0001;!\tY$)D\u0001=\u0015\tid(A\u0005wC2LG-\u0019;pe*\u0011q\bQ\u0001\tg\u0016\u001cWO]5us*\u0011\u0011\tF\u0001\u000bq2\u0004H.\u0019;g_Jl\u0017BA\"=\u0005=\u0019FO]5oOZ\u000bG.\u001b3bi>\u0014\u0018A\u00059bgN<xN\u001d3WC2LG-\u0019;pe\u0002\"\"AR$\u0011\u0005i!\u0001\"\u0002\u001d\b\u0001\u0004Q\u0004FA\u0004J!\tQU+D\u0001L\u0015\taU*\u0001\u0006b]:|G/\u0019;j_:T!AT(\u0002\u000f\u0019\f7\r^8ss*\u0011\u0001+U\u0001\u0006E\u0016\fgn\u001d\u0006\u0003%N\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002)\u0006\u0019qN]4\n\u0005Y[%!C!vi><\u0018N]3e\u0003\u0015\u0019\u0007.Z2l)\tIF\f\u0005\u0002\u001f5&\u00111l\b\u0002\u0005+:LG\u000fC\u0003^\u0011\u0001\u0007a,A\u0006vg\u0016\u0014\u0018iY2pk:$\bCA0g\u001b\u0005\u0001'BA1c\u0003\u00151wN]7t\u0015\t\u0019G-\u0001\u0002wc)\u0011QME\u0001\u0004CBL\u0017BA4a\u0005-)6/\u001a:BG\u000e|WO\u001c;\u0002\u001b\rDWmY6Vg\u0016\u0014h.Y7f)\tI&\u000eC\u0003^\u0013\u0001\u0007a,A\u0007dQ\u0016\u001c7\u000eU1tg^|'\u000f\u001a\u000b\u000336DQ!\u0018\u0006A\u0002y#\"!W8\t\u000bA\\\u0001\u0019\u0001\u0017\u0002\u0011A\f7o]<pe\u0012\f\u0001C^1mS\u0012\fG/\u001a)bgN<xN\u001d3\u0015\u0007M\f\u0019\u0001E\u0002usnl\u0011!\u001e\u0006\u0003m^\fA!\u001e;jY*\t\u00010\u0001\u0003kCZ\f\u0017B\u0001>v\u0005\u0011a\u0015n\u001d;\u0011\u0005q|X\"A?\u000b\u0005yt\u0014a\u00013u_&\u0019\u0011\u0011A?\u00031A\u000b7o]<pe\u00124\u0016\r\\5eCRLwN\u001c*fgVdG\u000fC\u0003q\u0019\u0001\u0007A\u0006K\u0002\u0005\u0003\u000f\u0001B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b\t\u0016AC:uKJ,w\u000e^=qK&!\u0011\u0011CA\u0006\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class UserAccountValidator {
    private final StringValidator passwordValidator;

    public static boolean isValidEmailAddress(String email) {
        return UserAccountValidator$.MODULE$.isValidEmailAddress(email);
    }

    public StringValidator passwordValidator() {
        return this.passwordValidator;
    }

    public void check(UserAccount userAccount) {
        Checks.checkNotNull((Object)userAccount, (String)"User Account can not be null.", (Object[])new Object[]{""});
        this.checkUsername(userAccount);
        if (!userAccount.isExternal()) {
            this.checkPassword(userAccount);
            return;
        }
    }

    public void checkUsername(UserAccount userAccount) {
        Checks.checkArgument((!Strings.isBlank((String)userAccount.getUsername()) ? 1 : 0) != 0, (String)"User name cannot be empty.", (Object[])new Object[0]);
        if (!userAccount.isExternal()) {
            Pattern pattern = Pattern.compile("^(?![\\.\\-_])(?!.*[\\.\\-_]{2})[\\w\\.\\-_]*[^\\W_]$", 256);
            Matcher matcher = pattern.matcher(userAccount.getUsername());
            Checks.checkArgument((boolean)matcher.matches(), (String)"All the alphanumeric characters and the special characters dash (-), underscore (_), and dot (.) are allowed. The special characters cannot be repeated more than once in a row. The username must not start or end with a special character.", (Object[])new Object[0]);
            return;
        }
    }

    public void checkPassword(UserAccount userAccount) {
        Checks.checkArgument((!Strings.isBlank((String)userAccount.getPassword()) ? 1 : 0) != 0, (String)"Password is required when creating a user.", (Object[])new Object[0]);
        if (!userAccount.isExternal()) {
            this.checkPassword(userAccount.getPassword());
            return;
        }
    }

    public void checkPassword(String password) {
        List invalids = this.passwordValidator().validate((Object)password).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)UserAccountValidator.$anonfun$checkPassword$1(x$1)));
        if (invalids.nonEmpty()) {
            throw new Checks.IncorrectArgumentException(((IterableOnceOps)new .colon.colon((Object)"Password needs to meet following requirements:", (List)Nil$.MODULE$).$plus$plus((IterableOnce)invalids.map((Function1 & Serializable)x$2 -> x$2.message()))).mkString(System.lineSeparator() + "\t"), new Object[0]);
        }
    }

    public java.util.List<PasswordValidationResult> validatePassword(String password) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.passwordValidator().validate((Object)password).map((Function1 & Serializable)vr -> new PasswordValidationResult(vr instanceof Valid, vr.message())).sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isValid()), Ordering.Boolean$.MODULE$.reverse())).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$checkPassword$1(ValidationResult x$1) {
        return x$1 instanceof Invalid;
    }

    @Autowired
    public UserAccountValidator(StringValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }
}

