/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.export.UnresolvedReferencesConfigurationItemConverter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.TemplateContent;
import com.xebialabs.xlrelease.export.TemplateImportContext;
import com.xebialabs.xlrelease.export.TemplateImportProcessor;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.views.ImportResult;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import scala.Function1;
import scala.Option$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ee!\u0002\n\u0014\u0003\u0003a\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u0011-\u0002!\u0011!Q\u0001\n1B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019\u0011\u0006\u0001)A\u0005q!)1\u000b\u0001D\u0001)\")!\r\u0001D\tG\")Q\u000e\u0001D\t]\"1Q\u0010\u0001D\u0001'yDq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002(\u0001!I!!\u000b\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA=\u0001\u0011%\u00111\u0010\u0005\b\u0003\u0003\u0003A\u0011BAB\u0011\u001d\ti\t\u0001C\u0005\u0003\u001f\u0013ACQ1tKR+W\u000e\u001d7bi\u0016LU\u000e]8si\u0016\u0014(B\u0001\u000b\u0016\u0003\u0019)\u0007\u0010]8si*\u0011acF\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001G\r\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\u000e\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005u!5C\u0001\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fM\u0006\tB/Y:l\u0003\u000e\u001cWm]:TKJ4\u0018nY3\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!*\u0012aB:feZL7-Z\u0005\u0003U\u001d\u0012\u0011\u0003V1tW\u0006\u001b7-Z:t'\u0016\u0014h/[2f\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\"AJ\u0017\n\u00059:#A\u0004*fY\u0016\f7/Z*feZL7-Z\u0001\u0018[\u0006L(-\u001a+f[Bd\u0017\r^3Qe>\u001cWm]:peN\u00042!\r\u001c9\u001b\u0005\u0011$BA\u001a5\u0003\u0011)H/\u001b7\u000b\u0003U\nAA[1wC&\u0011qG\r\u0002\t\u001fB$\u0018n\u001c8bYB\u0019\u0011'O\u001e\n\u0005i\u0012$\u0001\u0002'jgR\u0004\"\u0001P\u001f\u000e\u0003MI!AP\n\u0003/Q+W\u000e\u001d7bi\u0016LU\u000e]8siB\u0013xnY3tg>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003B\u001b:{\u0005c\u0001\u001f\u0001\u0005B\u00111\t\u0012\u0007\u0001\t\u0015)\u0005A1\u0001G\u0005\u0005!\u0016CA$K!\ty\u0002*\u0003\u0002JA\t9aj\u001c;iS:<\u0007C\u0001\u001fL\u0013\ta5CA\bUK6\u0004H.\u0019;f\u0007>tG/\u001a8u\u0011\u0015!C\u00011\u0001&\u0011\u0015YC\u00011\u0001-\u0011\u0015yC\u00011\u00011\u0003I!X-\u001c9mCR,\u0007K]8dKN\u001cxN]:\u0016\u0003a\n1\u0003^3na2\fG/\u001a)s_\u000e,7o]8sg\u0002\n\u0001b];qa>\u0014Ho]\u000b\u0003+r#\"AV-\u0011\u0005}9\u0016B\u0001-!\u0005\u001d\u0011un\u001c7fC:DQAW\u0004A\u0002m\u000bQ\"[7q_J$8i\u001c8uKb$\bCA\"]\t\u0015ivA1\u0001_\u0005\u0005)\u0016CA$`!\ta\u0004-\u0003\u0002b'\t)B+Z7qY\u0006$X-S7q_J$8i\u001c8uKb$\u0018!\u00063p%\u0016\fG\rV3na2\fG/Z\"p]R,g\u000e\u001e\u000b\u0004\u0005\u0012d\u0007\"B3\t\u0001\u00041\u0017aC5oaV$8\u000b\u001e:fC6\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u001b\u0002\u0005%|\u0017BA6i\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000biC\u0001\u0019A0\u00021\u0011|W\u000b]4sC\u0012,G+Z7qY\u0006$XmQ8oi\u0016tG\u000f\u0006\u0002pwB\u0019\u0011'\u000f9\u0011\u0005EDhB\u0001:w!\t\u0019\b%D\u0001u\u0015\t)8$\u0001\u0004=e>|GOP\u0005\u0003o\u0002\na\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011q\u000f\t\u0005\u0006y&\u0001\rAQ\u0001\u0010i\u0016l\u0007\u000f\\1uK\u000e{g\u000e^3oi\u0006\u0019Bm\\\"p]Z,'\u000f\u001e+p)\u0016l\u0007\u000f\\1uKR)q0a\u0003\u0002\u000eA!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006U\ta\u0001Z8nC&t\u0017\u0002BA\u0005\u0003\u0007\u0011qAU3mK\u0006\u001cX\rC\u0003}\u0015\u0001\u0007!\t\u0003\u0004\u0002\u0010)\u0001\r\u0001]\u0001\u0014I\u0016\u001cH/\u001b8bi&|gNR8mI\u0016\u0014\u0018\nZ\u0001\u000fS6\u0004xN\u001d;UK6\u0004H.\u0019;f)\u0019\t)\"a\t\u0002&A!\u0011'OA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f+\u0005)a/[3xg&!\u0011\u0011EA\u000e\u00051IU\u000e]8siJ+7/\u001e7u\u0011\u0015)7\u00021\u0001g\u0011\u0015Q6\u00021\u0001`\u0003UIW\u000e]8siR+W\u000e\u001d7bi\u0016\u001cuN\u001c;f]R$\u0002\"!\u0006\u0002,\u00055\u0012q\u0006\u0005\u0006y2\u0001\rA\u0011\u0005\u0007\u0003\u001fa\u0001\u0019\u00019\t\r\u0005EB\u00021\u0001p\u0003!9\u0018M\u001d8j]\u001e\u001c\u0018!\u0007:fg\u0016$XK\u001c3fGJL\b\u000f^3e!\u0006\u001c8o^8sIN$b!a\u000e\u0002>\u0005\u0005\u0003cA\u0010\u0002:%\u0019\u00111\b\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u007fi\u0001\u0019A@\u0002\u0011Q,W\u000e\u001d7bi\u0016Dq!!\r\u000e\u0001\u0004\t\u0019\u0005\u0005\u00032\u0003\u000b\u0002\u0018bAA$e\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u00021I,7/\u001a;V]\u0012,7M]=qi\u0016$\u0007+Y:to>\u0014H\rF\u0003W\u0003\u001b\nI\u0007C\u0004\u0002P9\u0001\r!!\u0015\u0002\u0005\rL\u0007\u0003BA*\u0003Kj!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0004k\u0012l'\u0002BA.\u0003;\n1!\u00199j\u0015\u0011\ty&!\u0019\u0002\rAdWoZ5o\u0015\r\t\u0019gF\u0001\tI\u0016\u0004Hn\\=ji&!\u0011qMA+\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c\u0005\b\u0003Wr\u0001\u0019AA7\u0003I\u0001(o\u001c9feRLH)Z:de&\u0004Ho\u001c:\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cRA!a\u001d\u0002Z\u00059!/\u001a4mK\u000e$\u0018\u0002BA<\u0003c\u0012!\u0003\u0015:pa\u0016\u0014H/\u001f#fg\u000e\u0014\u0018\u000e\u001d;pe\u0006i\"/Z7pm\u0016l\u0015n]:j]\u001e<\u0015\r^3EKB,g\u000eZ3oG&,7\u000f\u0006\u0004\u00028\u0005u\u0014q\u0010\u0005\u0007\u0003\u007fy\u0001\u0019A@\t\u000f\u0005Er\u00021\u0001\u0002D\u0005Y\"/Z7pm\u0016$&/[4hKJ\u001chi\u001c:S_>$hi\u001c7eKJ$\u0002\"a\u000e\u0002\u0006\u0006%\u00151\u0012\u0005\u0007\u0003\u000f\u0003\u0002\u0019\u00019\u0002\u001b\u0011,7\u000f^5oCRLwN\\%e\u0011\u0019\ty\u0004\u0005a\u0001\u007f\"9\u0011\u0011\u0007\tA\u0002\u0005\r\u0013a\u0006;f[Bd\u0017\r^3Fq&\u001cHo],ji\"$\u0016\u000e\u001e7f)\u00151\u0016\u0011SAK\u0011\u0019\t\u0019*\u0005a\u0001a\u0006Aam\u001c7eKJLE\r\u0003\u0004\u0002\u0018F\u0001\r\u0001]\u0001\u0006i&$H.\u001a")
public abstract class BaseTemplateImporter<T extends TemplateContent> {
    private final TaskAccessService taskAccessService;
    private final ReleaseService releaseService;
    private final List<TemplateImportProcessor> templateProcessors;

    private List<TemplateImportProcessor> templateProcessors() {
        return this.templateProcessors;
    }

    public abstract <U extends TemplateImportContext> boolean supports(U var1);

    public abstract T doReadTemplateContent(InputStream var1, TemplateImportContext var2);

    public abstract List<String> doUpgradeTemplateContent(T var1);

    public abstract Release doConvertToTemplate(T var1, String var2);

    public List<ImportResult> importTemplate(InputStream inputStream, TemplateImportContext importContext) {
        T templateContent = this.doReadTemplateContent(inputStream, importContext);
        List<String> upgradeWarnings = this.doUpgradeTemplateContent(templateContent);
        return this.importTemplateContent(templateContent, importContext.destinationFolderId(), upgradeWarnings);
    }

    private List<ImportResult> importTemplateContent(T templateContent, String destinationFolderId, List<String> warnings) {
        String destinationId = destinationFolderId == null ? Ids.ROOT_FOLDER_ID : destinationFolderId;
        Release template = this.doConvertToTemplate(templateContent, destinationId);
        template.getAttachments().forEach(attachment -> attachment.setFile((OverthereFile)templateContent.localFiles().get(attachment.getExportFilename())));
        Option$.MODULE$.apply((Object)template.getLogo()).foreach((Function1 & Serializable)logo -> {
            logo.setFile((OverthereFile)templateContent.localFiles().get(logo.getPortableFilename()));
            return BoxedUnit.UNIT;
        });
        Checks.checkArgument((boolean)template.isTemplate(), (String)"Only templates can be imported", (Object[])new Object[0]);
        this.taskAccessService.checkIfAuthenticatedUserCanUseTasks(template.getAllTasks());
        this.templateProcessors().forEach(processor -> warnings.addAll(processor.process(template, destinationId)));
        this.removeMissingGateDependencies(template, warnings);
        this.removeTriggersForRootFolder(destinationId, template, warnings);
        this.resetUndecryptedPasswords(template, warnings);
        while (this.templateExistsWithTitle(destinationId, template.getTitle())) {
            template.setTitle(RetryTitleGenerator.getNextTitle(template.getTitle()));
        }
        if (!template.hasScheduledStartDate()) {
            template.setScheduledStartDate(template.findFirstSetDate());
        }
        this.releaseService.importTemplate(template, destinationId);
        return Arrays.asList((Object[])new ImportResult[]{new ImportResult(template.getId(), template.getTitle(), warnings)});
    }

    private void resetUndecryptedPasswords(Release template, Collection<String> warnings) {
        BooleanRef issueWarning = BooleanRef.create((boolean)false);
        List configurationItems = CiHelper.getNestedCis((ConfigurationItem)template);
        configurationItems.forEach(configurationItem -> {
            Collection propertyDescriptors = configurationItem.getType().getDescriptor().getPropertyDescriptors();
            CollectionConverters$.MODULE$.CollectionHasAsScala(propertyDescriptors).asScala().foreach((Function1 & Serializable)propertyDescriptor -> {
                BaseTemplateImporter.$anonfun$resetUndecryptedPasswords$2(this, configurationItem, issueWarning, propertyDescriptor);
                return BoxedUnit.UNIT;
            });
        });
        if (issueWarning.elem) {
            warnings.add("Passwords could not be decrypted and have been reset.");
            return;
        }
    }

    private boolean resetUndecryptedPassword(ConfigurationItem ci, PropertyDescriptor propertyDescriptor) {
        PropertyKind propertyKind = propertyDescriptor.getKind();
        PropertyKind propertyKind2 = PropertyKind.STRING;
        if (!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null) && propertyDescriptor.isPassword()) {
            String passwordValue;
            String string = passwordValue = (String)propertyDescriptor.get(ci);
            String string2 = UnresolvedReferencesConfigurationItemConverter.DECRYPTION_FAILED_VALUE;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                propertyDescriptor.set(ci, null);
                return true;
            }
        }
        return false;
    }

    private void removeMissingGateDependencies(Release template, Collection<String> warnings) {
        template.getAllGates().forEach(gateTask -> gateTask.getDependencies().removeIf(dependency -> {
            boolean shouldBeRemoved = !dependency.hasVariableTarget() && !dependency.hasResolvedTarget() && !dependency.isArchived();
            Object object = shouldBeRemoved ? BoxesRunTime.boxToBoolean((boolean)warnings.add(String.format("Gate Task '%s' has a dependency on an unknown Release/Phase/Task", gateTask.getTitle()))) : BoxedUnit.UNIT;
            return shouldBeRemoved;
        }));
    }

    private void removeTriggersForRootFolder(String destinationId, Release template, Collection<String> warnings) {
        if (Ids.isRoot((String)destinationId) && !template.getReleaseTriggers().isEmpty()) {
            template.setReleaseTriggers(new ArrayList());
            warnings.add("Triggers could not be imported on the root folder.");
            return;
        }
    }

    private boolean templateExistsWithTitle(String folderId, String title) {
        return this.releaseService.templateExistsWithTitle(folderId, title);
    }

    public static final /* synthetic */ void $anonfun$resetUndecryptedPasswords$2(BaseTemplateImporter $this, ConfigurationItem configurationItem$1, BooleanRef issueWarning$1, PropertyDescriptor propertyDescriptor) {
        boolean decryptionFailed = $this.resetUndecryptedPassword(configurationItem$1, propertyDescriptor);
        if (decryptionFailed) {
            issueWarning$1.elem = true;
            return;
        }
    }

    public BaseTemplateImporter(TaskAccessService taskAccessService, ReleaseService releaseService, Optional<List<TemplateImportProcessor>> maybeTemplateProcessors) {
        this.taskAccessService = taskAccessService;
        this.releaseService = releaseService;
        this.templateProcessors = maybeTemplateProcessors.orElse(Collections.emptyList());
    }
}

