/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.ArchivingSettingsManager;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.BackgroundJobAction;
import com.xebialabs.xlrelease.utils.ArchivedReleaseExporter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.joda.time.LocalDateTime;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import scala.Function0;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005}a\u0001B\u0006\r\u0001UA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015)\b\u0001\"\u0011w\u0011\u0015a\b\u0001\"\u0003~\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007Aq!a\u0002\u0001\t\u0013\tIAA\u0006QkJ<W-Q2uS>t'BA\u0007\u000f\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0004\t\u0002\u0013ad'/\u001a7fCN,'BA\t\u0013\u0003%AXMY5bY\u0006\u00147OC\u0001\u0014\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001a\u0003H\u0016\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\rib\u0004I\u0007\u0002\u0019%\u0011q\u0004\u0004\u0002\u0014\u0005\u0006\u001c7n\u001a:pk:$'j\u001c2BGRLwN\u001c\t\u0003C!r!A\t\u0014\u0011\u0005\rBR\"\u0001\u0013\u000b\u0005\u0015\"\u0012A\u0002\u001fs_>$h(\u0003\u0002(1\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9\u0003\u0004\u0005\u0002-c5\tQF\u0003\u0002/_\u0005)1\u000f\u001c45U*\t\u0001'\u0001\u0005he&T(\u0010\\3e\u0013\t\u0011TFA\u0004M_\u001e<\u0017N\\4\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007CA\u000f6\u0013\t1DB\u0001\tBe\u000eD\u0017N^5oON+'O^5dK\u0006y\u0011M]2iSZLgnZ\"p]\u001aLw\r\u0005\u0002:y5\t!H\u0003\u0002<\u001d\u000511m\u001c8gS\u001eL!!\u0010\u001e\u00031\u0005\u00138\r[5wS:<7+\u001a;uS:<7/T1oC\u001e,'/A\u000bsKB|'\u000f^5oO*#'m\u0019+f[Bd\u0017\r^3\u0011\u0005\u0001KU\"A!\u000b\u0005\t\u001b\u0015\u0001B2pe\u0016T!\u0001R#\u0002\t)$'m\u0019\u0006\u0003\r\u001e\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0011\u0006\u0019qN]4\n\u0005)\u000b%\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0017\u0001E1sG\"Lg/\u001a3SK2,\u0017m]3t!\ti\u0005+D\u0001O\u0015\tye\"\u0001\u0002eE&\u0011\u0011K\u0014\u0002\u0011\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\fa\u0001P5oSRtD#\u0002+V-^C\u0006CA\u000f\u0001\u0011\u0015\u0019T\u00011\u00015\u0011\u00159T\u00011\u00019\u0011\u0015qT\u00011\u0001@\u0011\u0015YU\u00011\u0001M\u0003A\tX/\u001a:z\u0013\u0012,g\u000e^5gS\u0016\u00148\u000f\u0006\u0003\\I:\u001c\bc\u0001/bA9\u0011Ql\u0018\b\u0003GyK\u0011!G\u0005\u0003Ab\tq\u0001]1dW\u0006<W-\u0003\u0002cG\n!A*[:u\u0015\t\u0001\u0007\u0004C\u0003f\r\u0001\u0007a-\u0001\u0007k_\n\u001cF/\u0019:u)&lW\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006!A/[7f\u0015\tYw)\u0001\u0003k_\u0012\f\u0017BA7i\u00055aunY1m\t\u0006$X\rV5nK\")qN\u0002a\u0001a\u0006)\"n\u001c2Rk\u0016\u0014\u0018\u0010U3sS>$\u0017J\u001c%pkJ\u001c\bCA\fr\u0013\t\u0011\bDA\u0002J]RDQ\u0001\u001e\u0004A\u0002A\f\u0001\u0002]1hKNK'0Z\u0001\u0012aJ|7-Z:t\u0013\u0012,g\u000e^5gS\u0016\u0014HCA<{!\t9\u00020\u0003\u0002z1\t!QK\\5u\u0011\u0015Yx\u00011\u0001!\u0003)IG-\u001a8uS\u001aLWM]\u0001\u0013Kb\u0004xN\u001d;ECR\f\u0017J\u001a(fK\u0012,G\r\u0006\u0002x}\")q\u0010\u0003a\u0001A\u0005\u0011\u0011\u000eZ\u0001\u000bKb\u0004xN\u001d;ECR\fGcA<\u0002\u0006!)q0\u0003a\u0001A\u0005aq-\u001a;FqB|'\u000f\u001e#jeR!\u00111BA\u000e!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t!![8\u000b\u0005\u0005U\u0011\u0001\u00026bm\u0006LA!!\u0007\u0002\u0010\t!a)\u001b7f\u0011\u0019\tiB\u0003a\u0001A\u0005!\u0001/\u0019;i\u0001")
public class PurgeAction
implements BackgroundJobAction<String> {
    private final ArchivingService archivingService;
    private final ArchivingSettingsManager archivingConfig;
    private final JdbcTemplate reportingJdbcTemplate;
    private final ArchivedReleases archivedReleases;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void execute(BackgroundJobAction.JobExecutionContext context) {
        BackgroundJobAction.execute$(this, context);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PurgeAction purgeAction = this;
        synchronized (purgeAction) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public List<String> queryIdentifiers(LocalDateTime jobStartTime, int jobQueryPeriodInHours, int pageSize) {
        Date expirationDate = jobStartTime.minusHours(jobQueryPeriodInHours).toDate();
        return this.archivingService.findPurgableReleaseIds(expirationDate, pageSize).toList();
    }

    @Override
    public void processIdentifier(String identifier) {
        try {
            this.exportDataIfNeeded(identifier);
            this.archivingService.purgeArchivedRelease(identifier);
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> "Could not purge [" + identifier + "] from the archive: " + e.getMessage(), (Function0 & Serializable)() -> e);
        }
    }

    private void exportDataIfNeeded(String id) {
        if (this.archivingConfig.getExportOnPurgeEnabled()) {
            this.exportData(id);
            return;
        }
    }

    private void exportData(String id) {
        File exportDir = this.getExportDir(this.archivingConfig.getPurgeExportPath());
        ArchivedReleaseExporter exporter = new ArchivedReleaseExporter(this.reportingJdbcTemplate, exportDir, this.archivedReleases);
        String path = exporter.exportReleaseData(id);
        this.logger().info((Function0 & Serializable)() -> "Data for [" + id + "] exported to " + path);
    }

    private File getExportDir(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            try {
                dir.mkdirs();
                this.logger().debug((Function0 & Serializable)() -> "Created export directory for purged releases at '" + dir.getAbsolutePath() + "' based on provided path '" + path + "'");
            }
            catch (Exception e) {
                String msg = "Unable to create export directory for purged releases '" + path + "'.";
                throw new IllegalStateException(msg, e);
            }
        }
        if (!dir.isDirectory()) {
            String msg = "Purged release storage export directory path '" + path + "' does not point to a directory.";
            throw new IllegalStateException(msg);
        }
        return dir;
    }

    public PurgeAction(ArchivingService archivingService, ArchivingSettingsManager archivingConfig, JdbcTemplate reportingJdbcTemplate, ArchivedReleases archivedReleases) {
        this.archivingService = archivingService;
        this.archivingConfig = archivingConfig;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        this.archivedReleases = archivedReleases;
        Logging.$init$((Logging)this);
        BackgroundJobAction.$init$(this);
    }
}

