import json

from java.text import SimpleDateFormat
from java.util import Locale
from xlrxldeploy.status import *

global CI
global input

def parse_content(content):
    if content:
        version_tag = None
        if 'versionTag' in content:
            version_tag = content['versionTag']

        destination = None
        if 'destination' in content:
            destination = content['destination']

        destination_uid = None
        if 'destinationUid' in content:
            destination_uid = content['destinationUid']

        application_path = None
        if 'applicationPath' in content:
            application_path = content['applicationPath']

        status_group = None
        deployment_metadata = None
        if 'state' in content:
            state = content['state']
            status_group = map_status_group(state['deploymentStatus'])
            version_tag = state['versionTag']
            destination = state['destination']
            destination_uid = state['destinationUid']
            last_change = state["lastChangeTime"]
            sdf = SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX", Locale.US)
            change_time = None if last_change is None else sdf.parse(last_change)
            deployment_metadata = CI('events.WebhookStatusDeploymentMetadata', {
                'deploymentType': state['deploymentType'],
                'deploymentStatus': state['deploymentStatus'],
                'user': state['user'],
                'lastChangeTime': change_time,
            })


        return CI("events.StatusWebhookEvent", {
            'operation': content['operation'] if 'operation' in content else None,
            'applicationName': content['applicationName'],
            'applicationUid': content['applicationUid'],
            'applicationPath': application_path,
            'versionLabel': version_tag['label'],
            'versionState': None,
            'destination': destination,
            'destinationUid': destination_uid,
            'namespace': None,
            'statusGroup': status_group,
            'deploymentMetadata': deployment_metadata
        })
    else:
        return None

output = parse_content(json.loads(input.content))
