import React from 'react';
import { mountWithStoreAndTheme, ReactWrapper } from '@xlr-ui/tests/unit/testing-utils';
import { InputWithBoolean, RemoteScriptTextarea } from './script-interpolation.component';
import { PropertiesEnum, TaskInputCommonProps } from '@xlr-ui/app/features/tasks/components/rails/config/components/types';
import { stringPropertyMock } from '@xlr-ui/app/features/tasks/__mocks__/property.mock';
import { InputWithScalar } from '@xlr-ui/app/features/tasks/components/rails/config/components/input-with-scalar/input-with-scalar.component';
import { taskMock } from '@xlr-ui/app/features/tasks/__mocks__/task.mock';
import { RemoteScriptTask } from '@xlr-ui/app/types';

describe('remote script custom components', () => {
    let wrapper: ReactWrapper;

    const dispatch = jest.fn();
    const state = {};

    const disabled = false;
    const isSaving = false;
    const propertiesEnum = PropertiesEnum.InputProperties;
    const property = stringPropertyMock;

    const type = 'text';

    const componentProps: TaskInputCommonProps = {
        disabled,
        expanded: false,
        isSaving,
        onChange: jest.fn(),
        propertiesEnum,
        property,
        type,
    } as never;

    const getInputWithScalar = () => wrapper.find(InputWithScalar);

    describe('RemoteScriptTextarea', () => {
        const mount = (task: RemoteScriptTask) => {
            wrapper = mountWithStoreAndTheme(<RemoteScriptTextarea {...componentProps} task={task} />, dispatch, state);
        };

        it('should render InputWithScalar with interpolateVariables', () => {
            const remoteScriptTask = {
                inputProperties: {
                    scriptIgnoreVariableInterpolation: {
                        value: true,
                    },
                },
            } as never;
            mount(remoteScriptTask);
            const input = getInputWithScalar();
            expect(input.prop('type')).toBe('textarea');
            expect(input.prop('interpolateVariables')).toBe(false);
        });
        it('should render InputWithScalar without interpolateVariables', () => {
            const remoteScriptTask = {
                inputProperties: {
                    scriptIgnoreVariableInterpolation: {
                        value: false,
                    },
                },
            } as never;
            mount(remoteScriptTask);
            const input = getInputWithScalar();
            expect(input.prop('type')).toBe('textarea');
            expect(input.prop('interpolateVariables')).toBe(true);
        });
    });

    describe('InputWithBoolean', () => {
        it('should render InputWithScalar boolean', () => {
            wrapper = mountWithStoreAndTheme(<InputWithBoolean {...componentProps} task={taskMock} />, dispatch, state);
            const input = getInputWithScalar();
            expect(input.prop('type')).toBe('boolean');
        });
    });
});
