#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sets
import json
from xlrelease.HttpRequest import HttpRequest
import random

HTTP_SUCCESS = sets.Set([200, 201, 204])

class OpaClient:

    def __init__(self, server, username=None, password=None):
        if username and password:
            server['username'] = username
            server['password'] = password
        self.headers = {}
        self.httpRequest = HttpRequest(server, verify=False)
        if server['authenticationMethod'] == server['authenticationMethod'].PAT:
            bearer = "Bearer " + server['password']
            self.headers = {'Authorization': str(bearer)}

    def checkConnection(self):
        path = '/'
        response = self.httpRequest.get(context=path, contentType='application/json', headers=self.headers)
        return self.get_results(response, True)

    def createPolicy(self, policyName, data, githubURl=None, gitPat=None):
        path = "/v1/policies/" + policyName
        if not data:
            data = self.get_git_file_content(githubURl, gitPat)
        response = self.httpRequest.put(context=path,body=data,contentType='application/text', headers=self.headers)
        return self.get_results(response, False)

    def getPolicy(self, policyName):
        path = "/v1/policies/" + policyName
        response = self.httpRequest.get(context=path, headers=self.headers)
        return self.get_results(response, False)

    def updatePolicy(self, policyName, data, githubURl=None, gitPat=None):
        path = "/v1/policies/" + policyName
        if not data:
            data = self.get_git_file_content(githubURl, gitPat)
        response = self.httpRequest.put(context=path,body=data,contentType='application/text', headers=self.headers)
        return self.get_results(response, False)

    def evaluatePolicy(self, policyName, path, data):
        response = self.httpRequest.post(context=path,body=data,contentType='application/json', headers=self.headers)
        return self.get_results(response, False)

    def deletePolicy(self, policyName):
        path = "/v1/policies/" + policyName
        response = self.httpRequest.delete(context=path, headers=self.headers)
        return self.get_results(response, False)

    def get_results(self, response, isString):
        if response.getStatus() in HTTP_SUCCESS:
            if response.getResponse() is not None:
                if isString:
                    response.getResponse()
                else:
                    return json.loads(response.getResponse())
        else:
            raise Exception(
                "Error from server, HTTP Return: %s, content %s" % (response.getStatus(), response.getResponse()))

    def get_git_file_content(self, url, token):
        print "Extracting policy content from git path"
        server = {'url': url,'username': 'dummy%s'%random.randint(0,9),'password': token}
        httpRequest = HttpRequest(server, verify=False)
        response = httpRequest.get(context=None)
        if not response.isSuccessful():
            response.errorDump()
            raise Exception(
                "Error extracting Policy : %s, content %s" % (response.getStatus(), response.getResponse()))

        print "Policy extraction complete"
        return response.getResponse()

