import { Stage, StageState } from '../../../application-list.types';
import { PayloadAction, createSlice } from '@reduxjs/toolkit';
import noop from 'lodash/noop';

export const initialState: StageState = {
    stageList: [],
};

export const stageState = createSlice({
    name: 'stageState',
    initialState,
    reducers: {
        setStages: (state: StageState, action: PayloadAction<Array<Stage>>) => {
            state.stageList = action.payload;
        },
        searchStages: (_state: StageState, _action: PayloadAction<string>) => noop(),
        saveStage: (_state: StageState, _action: PayloadAction<Stage>) => noop(),
        deleteStage: (_state: StageState, _action: PayloadAction<Stage>) => noop(),
    },
});
