import { Stage } from '../../../application-list.types';
import { mountComponentWithStore } from '@xlr-ui/tests/unit/testing-utils';
import { StageEditModal } from './stage-edit-modal';
import React from 'react';
import { stages } from '../__mocks__/environment-list.mocks';
import { DotInputText } from '@digital-ai/dot-components';

describe('Stage edit modal', () => {
    const model: Stage = { id: '123', title: 'test stage' };
    const onCancel = jest.fn();
    const onSave = jest.fn();
    const state = {
        stageState: {
            stageList: stages,
        },
    };

    it('should be rendered', () => {
        const modal = mountComponentWithStore(<StageEditModal isOpened={true} model={model} onCancel={onCancel} onSave={onSave} />, jest.fn(), state);
        expect(modal).toExist();
        expect(modal.find(DotInputText).prop('defaultValue')).toBe('test stage');
    });

    it('should cancel form', () => {
        const modal = mountComponentWithStore(<StageEditModal isOpened={true} model={model} onCancel={onCancel} onSave={onSave} />, jest.fn(), state);
        const button = modal.find('button').at(0);
        expect(button.text()).toStrictEqual('Cancel');
        button.simulate('click');
        expect(onCancel).toHaveBeenCalledTimes(1);
    });

    it('should save form', () => {
        const modal = mountComponentWithStore(<StageEditModal isOpened={true} model={model} onCancel={onCancel} onSave={onSave} />, jest.fn(), state);
        const button = modal.find('button').at(1);
        expect(button.text()).toStrictEqual('Save');
        const input = modal.find(DotInputText);
        input.invoke('onChange')({ target: { value: 'test' } });
        button.simulate('click');
        expect(onSave).toBeCalledTimes(1);
    });

    it('should display validation message', () => {
        const modal = mountComponentWithStore(<StageEditModal isOpened={true} model={model} onCancel={onCancel} onSave={onSave} />, jest.fn(), state);
        const button = modal.find('button').at(1);
        expect(button.text()).toStrictEqual('Save');
        const input = modal.find(DotInputText);
        input.invoke('onChange')({ target: { value: 'someStage' } });
        expect(modal.find('#stage-modal-title-helper-text')).toExist();
    });
});
