import React from 'react';
import { ReactWrapper } from 'enzyme';
import { DotButton } from '@digital-ai/dot-components';
import { mountWithStoreAndTheme } from '@xlr-ui/tests/unit/testing-utils';
import { RemoteRunnersPlaceholder, RemoteRunnersPlaceholderProps } from './remote-runners-placeholder.component';
import { initialState } from '../ducks/remote-runners.reducer';
import { RootState } from '@xlr-ui/app/js/store.types';

const dispatch = jest.fn();
describe('RemoteRunnersPlaceholder component', () => {
    let wrapper: ReactWrapper;

    const onViewChangeMock = jest.fn();

    const defaultProps: RemoteRunnersPlaceholderProps = {
        onViewChange: onViewChangeMock,
    };

    const defaultState: RootState = {
        remoteRunners: initialState,
    };

    const mountComponent = (props: RemoteRunnersPlaceholderProps = defaultProps, state: RootState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<RemoteRunnersPlaceholder {...props} />, dispatch, state);
    };

    afterEach(() => {
        jest.resetAllMocks();
        wrapper.unmount();
    });

    const getAddRemoteRunnerButton = () => wrapper.findWhere((node) => node.is(DotButton) && node.props().className === 'remote-runners-create-btn');

    const searchDotCard = (selector: string) => wrapper.find(`.remote-runners-placeholder ${selector}`);

    it('should show the title and description', () => {
        mountComponent();
        expect(searchDotCard('.remote-runners-title').text()).toStrictEqual('Digital.ai Release runner overview');
        expect(searchDotCard('.remote-runners-description').text()).toContain(
            'Digital.ai Release runners handle Release task execution on remote servers. There are currently no Runners configured.',
        );
    });

    it('should show the add button', () => {
        mountComponent();
        expect(searchDotCard('.remote-runners-buttons button').at(0).text()).toStrictEqual('Install Runner');
    });

    it("should execute correct handler when 'Add remote runner' button has been clicked", () => {
        mountComponent();
        getAddRemoteRunnerButton().invoke('onClick')();
        expect(onViewChangeMock).toHaveBeenCalledTimes(1);
    });
});
