#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from argo.kube_client import KubeClient
from argo.commandParams import CommandHelper

rolloutName = task.pythonScript.getProperty("rolloutName")
expectedStatus = task.pythonScript.getProperty("expectedStatus")
retryWaitTime = task.pythonScript.getProperty("retryWaitTime")

flags = []
commandline_params = None
flags = CommandHelper.commandParams(rolloutsConf, flags)

if flags or params:
    commandline_params = '%s %s' % (" ".join(flags) if flags else '', params if params else '')

response = KubeClient(rolloutsConf['host'], rolloutsConf['kubectlPath'], rolloutsConf['kubectlArgoRolloutPath'], commandline_params).get_rollout_status(rolloutName)
task.setStatusLine("Rollout status is %s" % (response))

if (expectedStatus != response):
    task.schedule("argo/wait_for_status.py", retryWaitTime)
else:
    output = response


