#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import org.slf4j.LoggerFactory as LoggerFactory
from com.xebialabs.deployit.util import PasswordEncrypter



logger = LoggerFactory.getLogger("CRP")

params = {'url': configuration.url, 'username': configuration.username,
          'password': PasswordEncrypter.getInstance().ensureDecrypted(configuration.password),
          'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
          'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword,
          'proxyDomain': configuration.proxyDomain, 'id': configuration.id ,
          'authenticationMethod': configuration.authenticationMethod,
          'serverEnvironment': None, 'title': configuration.title ,'oauth2GrantType': configuration.oauth2GrantType, 'accessTokenUrl': configuration.accessTokenUrl, 'clientId': configuration.clientId,
          'clientSecret': PasswordEncrypter.getInstance().ensureDecrypted(configuration.clientSecret), 'scope': configuration.scope}


# send http request to the server to get a request back
OauthProvider = OAuthProvider(params)

token = OauthProvider.get_access_token()

# check response status code, if is different than 200 exit with error code
if token == None or len(token) == 0:
    raise Exception(
        "Error retrieving authorization token from Change Risk Prediction Server, Check the Credentials.
    )
else:
    logger.info('request was successful')
