#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from contextlib import closing

import java.util.ArrayList as ArrayList
import java.util.HashMap as HashMap
from com.xebialabs.xlrelease.lookup.api.internal import LookupResultElement
from scala.jdk.javaapi import CollectionConverters

# `application` holds the selected application id

s_phases = []
with closing(_ci.getClient()) as client:
    if application is not None and application != "":
        response = client.getApplication(application)
        if response:
            progression_details = client.getProgression(response["progression_id"])
            if progression_details:
                s_phases = progression_details["phases"]

t_phases = ArrayList(CollectionConverters.asJava(s_phases)) if s_phases else []
phases = [HashMap(CollectionConverters.asJava(p)) for p in t_phases]
result = [LookupResultElement(p.get("name"), p.get("id")) for p in phases]
