package com.xebialabs.xlrelease.support.akka.spring

import org.springframework.beans.BeansException
import org.springframework.context.{ApplicationContext, ApplicationContextAware}

trait ScalaSpringAwareBean extends ApplicationContextAware with ScalaSpringSupport {
  @transient
  var applicationContext: ApplicationContext = _

  override def getApplicationContext(): ApplicationContext = this.applicationContext

  @throws[BeansException]
  override def setApplicationContext(applicationContext: ApplicationContext): Unit = {
    this.applicationContext = applicationContext
  }
}
