package com.xebialabs.xlrelease.api.v1.views;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.xlrelease.domain.environments.Environment;

public class EnvironmentView {
    private String id;
    private String title;
    private String description;
    private EnvironmentStageView stage;
    private List<EnvironmentLabelView> labels = new ArrayList<>();

    public static EnvironmentView fromEnvironment(Environment environment) {
        EnvironmentView view = new EnvironmentView();
        view.setId(environment.getId());
        view.setTitle(environment.getTitle());
        view.setDescription(environment.getDescription());
        view.setStage(EnvironmentStageView.fromEnvironmentStage(environment.getStage()));
        view.setLabels(
                environment.getLabels()
                        .stream()
                        .map(EnvironmentLabelView::fromEnvironmentLabel)
                        .collect(Collectors.toList())
        );
        return view;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public EnvironmentStageView getStage() {
        return stage;
    }

    public void setStage(final EnvironmentStageView stage) {
        this.stage = stage;
    }

    public List<EnvironmentLabelView> getLabels() {
        return labels;
    }

    public void setLabels(final List<EnvironmentLabelView> labels) {
        this.labels = labels;
    }
}
