package com.xebialabs.xlrelease.api.v1.forms;

import java.io.Serializable;
import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;

@PublicApiRef
public abstract class AbstractDeliveryFilters implements Serializable {

    private String title = "";
    private boolean strictTitleMatch;
    private String trackedItemTitle = "";
    private boolean strictTrackedItemTitleMatch;
    private String folderId = "";

    public AbstractDeliveryFilters withTitle(String title) {
        this.title = title;
        return this;
    }

    public AbstractDeliveryFilters withStrictTitleMatch(boolean strictTitleMatch) {
        this.strictTitleMatch = strictTitleMatch;
        return this;
    }

    public AbstractDeliveryFilters withTrackedItemTitle(String title) {
        this.trackedItemTitle = title;
        return this;
    }

    public AbstractDeliveryFilters withStrictTrackedItemTitleMatch(boolean strictTitleMatch) {
        this.strictTrackedItemTitleMatch = strictTitleMatch;
        return this;
    }

    public AbstractDeliveryFilters withFolderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    public abstract List<DeliveryStatus> getStatuses();


    public boolean hasStatuses() {
        return getStatuses() != null && !getStatuses().isEmpty();
    }

    // getters / setters

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public boolean isStrictTitleMatch() {
        return strictTitleMatch;
    }

    public String getTrackedItemTitle() {
        return trackedItemTitle;
    }

    public boolean isStrictTrackedItemTitleMatch() {
        return strictTrackedItemTitleMatch;
    }

    public void setStrictTitleMatch(final boolean strictTitleMatch) {
        this.strictTitleMatch = strictTitleMatch;
    }
}
