package com.xebialabs.xlrelease.api.v1.views;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.reflect.Type;

import static com.google.common.collect.Sets.intersection;
import static com.google.common.collect.Sets.newHashSet;

public class TaskAccessView {

    private String taskGroup;
    private String taskType;
    private String label;
    private boolean allowedToAll;
    private List<String> roles;

    public TaskAccessView() {
    }

    public TaskAccessView(String taskGroup, String taskType, String label, boolean allowedToAll, List<String> roles) {
        this.taskGroup = taskGroup;
        this.taskType = taskType;
        this.label = label;
        this.allowedToAll = allowedToAll;
        this.roles = roles;
    }

    public String getTaskGroup() {
        return taskGroup;
    }

    public String getTaskType() {
        return taskType;
    }

    public String getLabel() {
        return label;
    }

    public boolean isAllowedToAll() {
        return allowedToAll;
    }

    public void setAllowedToAll(boolean allowedToAll) {
        this.allowedToAll = allowedToAll;
    }

    public List<String> getRoles() {
        return roles;
    }

    public Type toType() {
        return Type.valueOf(taskType);
    }

    public boolean isGrantedForRoles(Set<String> roleNamesForAuthenticatedUser) {
        if (isAllowedToAll()) {
            return true;
        } else {
            Collection<?> intersection = intersection(roleNamesForAuthenticatedUser, newHashSet(getRoles()));
            return ! intersection.isEmpty();
        }
    }
}
