package com.xebialabs.xlrelease.param;

import java.lang.annotation.Annotation;
import java.util.Date;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;
import org.joda.time.format.ISODateTimeFormat;
import com.google.common.base.Strings;

public class DateParamUnmarshaller implements StringParameterUnmarshaller<Date> {

    @Override
    public void setAnnotations(final Annotation[] annotations) {
    }

    @Override
    public Date fromString(final String str) {
        return parseDate(str);
    }

    private Date parseDate(String date) throws UnsupportedOperationException, IllegalArgumentException {
        if (Strings.isNullOrEmpty(date)) {
            return null;
        }
        try {
            return new Date(Long.parseLong(date));
        } catch (NumberFormatException e1) {
            try {
                return ISODateTimeFormat.dateTimeParser().parseDateTime(date).toDate();
            } catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException(
                        String.format("Error parsing date parameter: '%s': must be either in milliseconds (since 1 January 1970) or an ISO8601 formatted date", date),
                        e2
                );
            }
        }
    }
}
