/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.filter;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.time.Duration;
import java.util.Date;
import java.util.List;

@PublicApiRef
public class ReservationFilters {
    private String environmentTitle;
    private List<String> stages;
    private List<String> labels;
    private List<String> applications;
    private Date from;
    private Date to;

    public ReservationFilters() {
    }

    public ReservationFilters(String environmentTitle, List<String> stages, List<String> labels, List<String> applications, Date from, Date to) {
        this.environmentTitle = environmentTitle;
        this.stages = stages;
        this.labels = labels;
        this.applications = applications;
        this.from = from;
        this.to = to;
    }

    public void validate() {
        Checks.checkArgument((this.from != null ? 1 : 0) != 0, (String)"Start date is required", (Object[])new Object[0]);
        Checks.checkArgument((this.to != null ? 1 : 0) != 0, (String)"End date is required", (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.from.before(this.to), (String)"Start date must be before the end date", (Object[])new Object[0]);
        Checks.checkArgument((Duration.between(this.from.toInstant(), this.to.toInstant()).toDays() <= 90L ? 1 : 0) != 0, (String)"Start date and end date must be 90 or less days apart", (Object[])new Object[0]);
    }

    public String getEnvironmentTitle() {
        return this.environmentTitle;
    }

    public void setEnvironmentTitle(String environmentTitle) {
        this.environmentTitle = environmentTitle;
    }

    public List<String> getStages() {
        return this.stages;
    }

    public void setStages(List<String> stages) {
        this.stages = stages;
    }

    public List<String> getApplications() {
        return this.applications;
    }

    public void setApplications(List<String> applications) {
        this.applications = applications;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }
}

