package com.xebialabs.xlrelease.api.v1.forms;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonInclude;

import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.UserProfile;

/**
 * A compound object containing user information, using in API
 */
@PublicApiRef
@ShowOnlyPublicApiMembers
public class UserAccount {
    private String username;
    private boolean external;
    private String profileId;
    private String email;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String password;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String previousPassword;
    private String fullName;
    private String externalId;
    private boolean loginAllowed;
    private String dateFormat;
    private String timeFormat;
    private Integer firstDayOfWeek;
    private Date lastActive;
    private boolean analyticsEnabled = true;
    private boolean taskDrawerEnabled = true;
    private boolean personalAccessTokenEnabled = false;

    @PublicApiMember
    @SuppressWarnings("unused")
    public UserAccount() {
    }

    public UserAccount(String username, UserProfile profile, boolean isInternal) {
        this.username = username;
        this.external = !isInternal;
        if (profile != null) {
            this.profileId = profile.getId();
            this.email = profile.getEmail();
            this.fullName = profile.getFullName();
            this.externalId = profile.getExternalId();
            this.loginAllowed = profile.isLoginAllowed();
            this.dateFormat = profile.getDateFormat();
            this.timeFormat = profile.getTimeFormat();
            this.firstDayOfWeek = profile.getFirstDayOfWeek();
            this.lastActive = profile.getLastActive();
            this.analyticsEnabled = profile.isAnalyticsEnabled();
            this.taskDrawerEnabled = profile.isTaskDrawerEnabled();
        }
    }

    public UserAccount(String username, UserProfile profile, boolean isInternal, boolean personalAccessTokenEnabled) {
        this(username, profile, isInternal);
        this.personalAccessTokenEnabled = personalAccessTokenEnabled;
    }

    public UserProfile toUserProfile() {
        UserProfile profile = new UserProfile(username, email, fullName, loginAllowed, lastActive, externalId);
        profile.setDateFormat(dateFormat);
        profile.setTimeFormat(timeFormat);
        profile.setFirstDayOfWeek(firstDayOfWeek);
        profile.setAnalyticsEnabled(analyticsEnabled);
        profile.setTaskDrawerEnabled(taskDrawerEnabled);
        return profile;
    }

    @PublicApiMember
    public String getUsername() {
        return username;
    }

    @PublicApiMember
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isExternal() {
        return external;
    }

    public boolean isPersonalAccessTokenEnabled() {
        return personalAccessTokenEnabled;
    }

    public String getProfileId() {
        return profileId;
    }

    @PublicApiMember
    public String getEmail() {
        return email;
    }

    @PublicApiMember
    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    @PublicApiMember
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasPassword() {
        return password != null && !password.isEmpty();
    }

    public String getPreviousPassword() {
        return previousPassword;
    }

    public void setPreviousPassword(String previousPassword) {
        this.previousPassword = previousPassword;
    }

    @PublicApiMember
    public String getFullName() {
        return fullName;
    }

    @PublicApiMember
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @PublicApiMember
    public String getExternalId() {
        return externalId;
    }

    @PublicApiMember
    public void setExternalId(final String externalId) {
        this.externalId = externalId;
    }

    @PublicApiMember
    public boolean isLoginAllowed() {
        return loginAllowed;
    }

    @PublicApiMember
    public void setLoginAllowed(boolean loginAllowed) {
        this.loginAllowed = loginAllowed;
    }

    @PublicApiMember
    public String getDateFormat() {
        return dateFormat;
    }

    @PublicApiMember
    public void setDateFormat(final String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @PublicApiMember
    public Integer getFirstDayOfWeek() {
        return firstDayOfWeek;
    }

    @PublicApiMember
    public void setFirstDayOfWeek(final Integer firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    @PublicApiMember
    public String getTimeFormat() {
        return timeFormat;
    }

    @PublicApiMember
    public void setTimeFormat(final String timeFormat) {
        this.timeFormat = timeFormat;
    }

    @PublicApiMember
    public Date getLastActive() {
        return lastActive;
    }

    @PublicApiMember
    public void setLastActive(Date lastActive) {
        this.lastActive = lastActive;
    }

    @PublicApiMember
    public boolean isAnalyticsEnabled() {
        return analyticsEnabled;
    }

    @PublicApiMember
    public void setAnalyticsEnabled(boolean analyticsEnabled) {
        this.analyticsEnabled = analyticsEnabled;
    }

    @PublicApiMember
    public boolean isTaskDrawerEnabled() {
        return taskDrawerEnabled;
    }

    @PublicApiMember
    public void setTaskDrawerEnabled(boolean taskDrawerEnabled) {
        this.taskDrawerEnabled = taskDrawerEnabled;
    }

}
