/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.forms;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderDirection;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.RiskStatusWithThresholds;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@PublicApiRef
public class ReleasesFilters {
    private String title;
    private List<String> tags;
    private List<String> taskTags;
    private TimeFrame timeFrame;
    private Date from;
    private Date to;
    private boolean active;
    private boolean planned;
    private boolean inProgress;
    private boolean paused;
    private boolean failing;
    private boolean failed;
    private boolean inactive;
    private boolean completed;
    private boolean aborted;
    private boolean onlyMine;
    private boolean onlyFlagged;
    private boolean onlyArchived;
    private String parentId;
    private String templateId;
    private ReleaseOrderMode orderBy;
    private ReleaseOrderDirection orderDirection;
    private RiskStatusWithThresholds riskStatusWithThresholds;
    private ReleaseKind kind = ReleaseKind.RELEASE;
    private List<String> categories;

    public boolean hasASelectedFilter() {
        return this.active || this.planned || this.inProgress || this.paused || this.failing || this.failed || this.inactive || this.completed || this.aborted || this.onlyMine || this.onlyArchived;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getFrom() {
        return this.from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public boolean withPlanned() {
        return this.planned;
    }

    public void setPlanned(boolean planned) {
        this.planned = planned;
    }

    public boolean withActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean withInProgress() {
        return this.inProgress;
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public boolean withPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean withFailing() {
        return this.failing;
    }

    public void setFailing(boolean failing) {
        this.failing = failing;
    }

    public boolean withFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean withInactive() {
        return this.inactive;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }

    public boolean withCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public boolean withAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean withOnlyMine() {
        return this.onlyMine;
    }

    public void setOnlyMine(boolean onlyMine) {
        this.onlyMine = onlyMine;
    }

    public boolean withOnlyFlagged() {
        return this.onlyFlagged;
    }

    public void setOnlyFlagged(boolean onlyFlagged) {
        this.onlyFlagged = onlyFlagged;
    }

    public boolean withOnlyArchived() {
        return this.onlyArchived;
    }

    public void setOnlyArchived(boolean onlyArchived) {
        this.onlyArchived = onlyArchived;
    }

    public TimeFrame getTimeFrame() {
        return this.timeFrame;
    }

    public void setTimeFrame(TimeFrame timeFrame) {
        this.timeFrame = timeFrame;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public static ReleasesFilters active() {
        ReleasesFilters rf = new ReleasesFilters();
        rf.setActive(true);
        return rf;
    }

    public Date getQueryStartDate() {
        if (this.timeFrame != null) {
            return new Date(this.timeFrame.getStartDate(this.from));
        }
        return this.from;
    }

    public Date getQueryEndDate() {
        if (this.timeFrame != null) {
            return new Date(this.timeFrame.getEndDate(this.to));
        }
        return this.to;
    }

    public ReleaseOrderMode getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(ReleaseOrderMode orderBy) {
        this.orderBy = orderBy;
    }

    public ReleaseOrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    public void setOrderDirection(ReleaseOrderDirection orderDirection) {
        this.orderDirection = orderDirection;
    }

    public RiskStatusWithThresholds getRiskStatusWithThresholds() {
        return this.riskStatusWithThresholds;
    }

    public void setRiskStatusWithThresholds(RiskStatusWithThresholds riskStatusWithThresholds) {
        this.riskStatusWithThresholds = riskStatusWithThresholds;
    }

    public ReleaseKind getKind() {
        return this.kind;
    }

    public void setKind(ReleaseKind kind) {
        this.kind = kind;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<String> getTaskTags() {
        return this.taskTags;
    }

    public ReleasesFilters setTaskTags(List<String> taskTags) {
        this.taskTags = taskTags;
        return this;
    }

    public List<ReleaseStatus> getStatuses() {
        ArrayList<ReleaseStatus> statuses = new ArrayList<ReleaseStatus>();
        if (this.withPlanned()) {
            statuses.add(ReleaseStatus.PLANNED);
        }
        if (this.withActive()) {
            statuses.addAll(Arrays.stream(ReleaseStatus.ACTIVE_STATUSES).collect(Collectors.toList()));
        } else {
            if (this.withInProgress()) {
                statuses.add(ReleaseStatus.IN_PROGRESS);
            }
            if (this.withPaused()) {
                statuses.add(ReleaseStatus.PAUSED);
            }
            if (this.withFailing()) {
                statuses.add(ReleaseStatus.FAILING);
            }
            if (this.withFailed()) {
                statuses.add(ReleaseStatus.FAILED);
            }
        }
        if (this.withInactive()) {
            statuses.addAll(Arrays.stream(ReleaseStatus.INACTIVE_STATUSES).collect(Collectors.toList()));
        } else {
            if (this.withCompleted()) {
                statuses.add(ReleaseStatus.COMPLETED);
            }
            if (this.withAborted()) {
                statuses.add(ReleaseStatus.ABORTED);
            }
        }
        return statuses;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }
}

