package com.xebialabs.xlrelease.api.v1.forms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;

import static java.util.Arrays.asList;

@PublicApiRef
public class DeliveryFilters extends AbstractDeliveryFilters {
    private String originPatternId = "";

    private List<DeliveryStatus> statuses = new ArrayList<>();

    private static final List<DeliveryStatus> ALL_STATUSES = Arrays.stream(DeliveryStatus.values())
            .filter(value -> value != DeliveryStatus.TEMPLATE)
            .collect(Collectors.toList());

    public DeliveryFilters withOriginPatternId(String originPatternId) {
        this.originPatternId = originPatternId;
        return this;
    }

    public DeliveryFilters withStatuses(DeliveryStatus... statuses) {
        this.statuses = asList(statuses);
        return this;
    }

    public String getOriginPatternId() {
        return originPatternId;
    }

    public void setOriginPatternId(final String originPatternId) {
        this.originPatternId = originPatternId;
    }


    public List<DeliveryStatus> getStatuses() {
        if (statuses.isEmpty()) {
            return ALL_STATUSES;
        }
        return statuses;
    }

    public void setStatuses(final List<DeliveryStatus> statuses) {
        this.statuses = statuses;
    }

}
