package com.xebialabs.xlrelease.api.v1.form;

import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.environments.Environment;
import com.xebialabs.xlrelease.domain.environments.EnvironmentLabel;
import com.xebialabs.xlrelease.domain.environments.EnvironmentStage;

public class EnvironmentForm {
    private String folderId;
    private String title;
    private String description;
    private String stageId;
    private List<String> labelIds = null;

    public Environment toEnvironment() {
        Environment environment = new Environment();
        environment.setId(null);
        environment.setFolderId(this.getFolderId());
        environment.setTitle(this.getTitle());
        environment.setDescription(this.getDescription());
        EnvironmentStage stage = new EnvironmentStage();
        stage.setId(this.getStageId());
        environment.setStage(stage);

        if (labelIds != null) {
            List<EnvironmentLabel> labels = labelIds
                    .stream()
                    .map(id -> Type.valueOf(EnvironmentLabel.class).getDescriptor().<EnvironmentLabel>newInstance(id))
                    .collect(Collectors.toList());

            environment.setLabels(labels);
        }

        return environment;
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public String getStageId() {
        return stageId;
    }

    public void setStageId(final String stageId) {
        this.stageId = stageId;
    }

    public List<String> getLabelIds() {
        return labelIds;
    }

    public void setLabelIds(final List<String> labelIds) {
        this.labelIds = labelIds;
    }
}
