package com.xebialabs.xlrelease.api.v1.forms;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.serialization.json.jackson.PasswordDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.PasswordSerializer;

/**
 * All the parameters needed to create a release.
 */
@PublicApiRef
public class CreateRelease {

    /**
     * The release's title
     */
    private String releaseTitle;

    /**
     * The folderId in which the release should be created, or null if on global level or same folder as template this release is created from.
     */
    private String folderId;

    /**
     * A list containing the release's {@link Variable}s.
     */
    private Map<String, Object> variables = new HashMap<>();

    /**
     * A map containing the release's variables and values: keys are variable names (eg: ${serverUrl}), values are the variable values (eg: "http://url.to.server").
     */
    private Map<String, String> releaseVariables = new HashMap<>();

    /**
     * A map containing the release's password variables and values: keys are variable names (eg: ${serverPassword}), values are the password (eg: "secret").
     */
    @JsonSerialize(contentUsing = PasswordSerializer.class)
    @JsonDeserialize(contentUsing = PasswordDeserializer.class)
    private Map<String, String> releasePasswordVariables = new HashMap<>();

    private Date scheduledStartDate;

    private boolean autoStart = false;

    /**
     * Specifies the id the task that created the release
     */
    private String startedFromTaskId;

    /**
     * Specifies the release owner
     */
    private String releaseOwner;

    public CreateRelease() {
    }

    public CreateRelease(String title, String folderId, Map<String, String> variables, Map<String, String> releasePasswordVariables) {
        this.releaseTitle = title;
        this.folderId = folderId;
        setReleasePasswordVariables(releasePasswordVariables);
        setReleaseVariables(variables);
    }

    public CreateRelease(String title, String folderId, Map<String, Object> variables) {
        this.releaseTitle = title;
        this.folderId = folderId;
        this.variables = variables;
    }

    public String getReleaseTitle() {
        return releaseTitle;
    }

    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    /**
     * @deprecated Please use {@link CreateRelease#getVariables()}
     */
    @Deprecated
    public Map<String, String> getReleaseVariables() {
        return releaseVariables;
    }

    /**
     * @param variables A map containing the release's variables and values: keys are variable names (eg: ${serverUrl}), values are the variable values (eg: "http://url.to.server").
     * @deprecated Please use {@link CreateRelease#setVariables(Map)}
     */
    @Deprecated
    public void setReleaseVariables(Map<String, String> variables) {
        this.releaseVariables = variables;
        this.variables.putAll(variables);
    }

    /**
     * @deprecated Please use {@link CreateRelease#getVariables()}
     */
    @Deprecated
    public Map<String, String> getReleasePasswordVariables() {
        return releasePasswordVariables;
    }

    /**
     * @param releasePasswordVariables A map containing the release's password variables and values: keys are variable names (eg: ${serverPassword}), values are the password (eg: "secret").
     * @deprecated Please use {@link CreateRelease#setVariables(Map)}
     */
    @Deprecated
    public void setReleasePasswordVariables(Map<String, String> releasePasswordVariables) {
        this.releasePasswordVariables = releasePasswordVariables;
        this.variables.putAll(releasePasswordVariables);
    }

    public Date getScheduledStartDate() {
        return scheduledStartDate;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public boolean getAutoStart() {
        return autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean hasScheduledStartDate() {
        return null != scheduledStartDate;
    }

    public Map<String, Object> getVariables() {
        return variables;
    }

    /**
     *  @param variables A map containing the release's variables and values: keys are variable names (eg: serverPassword), values are the values of the variable (eg: "secret").
     */
    public void setVariables(final Map<String, Object> variables) {
        this.variables.putAll(variables);
    }

    public String getStartedFromTaskId() {
        return startedFromTaskId;
    }

    public void setStartedFromTaskId(final String startedFromTaskId) {
        this.startedFromTaskId = startedFromTaskId;
    }

    public String getReleaseOwner() {
        return releaseOwner;
    }

    public void setReleaseOwner(final String releaseOwner) {
        this.releaseOwner = releaseOwner;
    }
}
