package com.xebialabs.xlrelease.api.v1.forms;

import java.util.Collections;
import java.util.Date;
import java.util.Set;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

@PublicApiRef
public class CreatePersonalAccessTokenForm {

    private String tokenNote;

    private Date expiryDate;

    private Set<String> globalPermissions = Collections.emptySet();

    public CreatePersonalAccessTokenForm() {
    }

    public CreatePersonalAccessTokenForm(final String tokenNote) {
        this.tokenNote = tokenNote;
    }

    public CreatePersonalAccessTokenForm(final String tokenNote,
                                         final Date expiryDate,
                                         final Set<String> globalPermissions) {
        this.tokenNote = tokenNote;
        this.expiryDate = expiryDate;
        this.globalPermissions = globalPermissions;
    }

    public String getTokenNote() {
        return tokenNote;
    }

    public void setTokenNote(final String tokenNote) {
        this.tokenNote = tokenNote;
    }

    public Date getExpiryDate() {
        return expiryDate;
    }

    public void setExpiryDate(final Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Set<String> getGlobalPermissions() {
        return globalPermissions;
    }

    public void setGlobalPermissions(final Set<String> globalPermissions) {
        this.globalPermissions = globalPermissions;
    }

}
