/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.views.search;

import com.xebialabs.xlrelease.api.v1.views.BaseApplicationView;
import com.xebialabs.xlrelease.domain.environments.EnvironmentReservation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

class ReservationSearchView {
    private String id;
    private Date startDate;
    private Date endDate;
    private String note;
    private List<BaseApplicationView> applications = new ArrayList<BaseApplicationView>();

    ReservationSearchView() {
    }

    static ReservationSearchView fromEnvironmentReservation(EnvironmentReservation reservation) {
        ReservationSearchView view = new ReservationSearchView();
        view.id = reservation.getId();
        view.startDate = reservation.getStartDate();
        view.endDate = reservation.getEndDate();
        view.note = reservation.getNote();
        view.applications = reservation.getApplications().stream().map(BaseApplicationView::fromApplication).collect(Collectors.toList());
        return view;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public List<BaseApplicationView> getApplications() {
        return this.applications;
    }

    public void setApplications(List<BaseApplicationView> application) {
        this.applications = application;
    }
}

