/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.forms;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.Date;
import org.joda.time.DateTime;

@PublicApiRef
public enum TimeFrame {
    LAST_SEVEN_DAYS{

        @Override
        public long getStartDate(Date from) {
            return new DateTime().minusDays(7).getMillis();
        }

        @Override
        public long getEndDate(Date to) {
            return new Date().getTime();
        }
    }
    ,
    LAST_MONTH{

        @Override
        public long getStartDate(Date from) {
            return new DateTime().minusMonths(1).getMillis();
        }

        @Override
        public long getEndDate(Date to) {
            return new Date().getTime();
        }
    }
    ,
    LAST_THREE_MONTHS{

        @Override
        public long getStartDate(Date from) {
            return new DateTime().minusMonths(3).getMillis();
        }

        @Override
        public long getEndDate(Date to) {
            return new Date().getTime();
        }
    }
    ,
    LAST_SIX_MONTHS{

        @Override
        public long getStartDate(Date from) {
            return new DateTime().minusMonths(6).getMillis();
        }

        @Override
        public long getEndDate(Date to) {
            return new Date().getTime();
        }
    }
    ,
    LAST_YEAR{

        @Override
        public long getStartDate(Date from) {
            return new DateTime().minusYears(1).getMillis();
        }

        @Override
        public long getEndDate(Date to) {
            return new Date().getTime();
        }
    }
    ,
    RANGE{

        @Override
        public long getStartDate(Date from) {
            return from != null ? from.getTime() : 0L;
        }

        @Override
        public long getEndDate(Date to) {
            return to != null ? to.getTime() : new Date().getTime();
        }
    };

    public static final String DEFAULT_TIME_FRAME = "LAST_SEVEN_DAYS";

    public abstract long getStartDate(Date var1);

    public abstract long getEndDate(Date var1);
}

