package com.xebialabs.xlrelease.api.v1.filter;

import java.util.List;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

@PublicApiRef
public class ApplicationFilters {
    private String title;
    private String folderId;
    private List<String> environments;

    private ApplicationEnvironmentFilterScope scope;

    public ApplicationFilters(ApplicationEnvironmentFilterScope scope) {
        this.scope = scope;
    }

    public ApplicationFilters() {
    }

    public ApplicationFilters(final String folderId, final String title, final List<String> environments) {
        this.folderId = folderId;
        this.title = title;
        this.environments = environments;
    }


    public ApplicationFilters withTitle(String title) {
        this.title = title;
        return this;
    }

    public ApplicationEnvironmentFilterScope getScope() {
        return scope;
    }

    public void setScope(ApplicationEnvironmentFilterScope scope) {
        this.scope = scope;
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(String folderId) {
        this.folderId = folderId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public List<String> getEnvironments() {
        return environments;
    }

    public void setEnvironments(final List<String> environments) {
        this.environments = environments;
    }
}
