package com.xebialabs.xlrelease.api.v1.views;

import java.util.Date;
import java.util.List;

import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;

public class ReleaseTimeline extends PlanItemTimeline {
    private static String RISK_SCORE = "riskScore";

    private List<PhaseTimeline> phases;

    private int riskScore;

    private ReleaseStatus status;

    public ReleaseTimeline(Release release, Date plannedStartDate, Date plannedEndDate) {
        super(release, plannedStartDate, plannedEndDate);
        this.riskScore = Integer.parseInt(release.getProperty(RISK_SCORE));
        this.status = release.getStatus();
    }

    public ReleaseStatus getStatus() {
        return status;
    }

    public void setStatus(final ReleaseStatus status) {
        this.status = status;
    }

    public List<PhaseTimeline> getPhases() {
        return phases;
    }

    public void setPhases(final List<PhaseTimeline> phases) {
        this.phases = phases;
    }

    public int getRiskScore() {
        return riskScore;
    }

    public void setRiskScore(final int riskScore) {
        this.riskScore = riskScore;
    }

}
