package com.xebialabs.xlrelease.api.v1.filter;

import java.util.HashSet;
import java.util.Set;

import com.xebialabs.xlrelease.domain.status.ReleaseStatus;

public class WorkflowFilters {
    private String searchInput;
    private String author;
    private Set<String> categories = new HashSet<>();
    private Set<String> tags = new HashSet<>();
    private Set<String> excludeTags = new HashSet<>();
    private String folderId;
    private Set<ReleaseStatus> statuses = Set.of(ReleaseStatus.TEMPLATE);
    private WorkflowOrderMode orderMode;

    public WorkflowFilters() {
    }

    public String getSearchInput() {
        return searchInput;
    }

    public void setSearchInput(final String searchInput) {
        this.searchInput = searchInput;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(final String author) {
        this.author = author;
    }

    public Set<String> getCategories() {
        return categories;
    }

    public void setCategories(final Set<String> categories) {
        this.categories = categories;
    }

    public Set<String> getTags() {
        return tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Set<String> getExcludeTags() {
        return excludeTags;
    }

    public void setExcludeTags(final Set<String> excludeTags) {
        this.excludeTags = excludeTags;
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    public Set<ReleaseStatus> getStatuses() {
        return statuses;
    }

    public void setStatuses(final Set<ReleaseStatus> statuses) {
        this.statuses = statuses;
    }

    public WorkflowOrderMode getOrderMode() {
        return orderMode;
    }

    public void setOrderMode(WorkflowOrderMode orderMode) {
        this.orderMode = orderMode;
    }

    @Override
    public String toString() {
        return "WorkflowFilters [" +
                "searchInput='" + searchInput + '\'' +
                ", author='" + author + '\'' +
                ", categories=" + categories +
                ", folderId='" + folderId + '\'' +
                ", statuses=" + statuses +
                ']';
    }
}
