package com.xebialabs.xlrelease.plugin

import grizzled.slf4j.Logging
import org.springframework.util.AntPathMatcher

import java.io.File
import java.net.URL
import java.util.zip.{ZipEntry, ZipFile}
import scala.jdk.CollectionConverters.EnumerationHasAsScala

case class ZipPlugin(file: File) extends JarBasedPlugin with Logging {
  val zipFile = new ZipFile(file)

  override def getResources(name: String): Seq[URL] = {
    Option(zipFile.getEntry(name)) match {
      case Some(entry) => Seq(entryUrl(entry))
      case None => Seq.empty
    }
  }

  override def close(): Unit = zipFile.close()

  override def find(pathPattern: String): Seq[URL] = {
    val pathMatcher = new AntPathMatcher()

    zipFile.entries().asScala
      .filter(entry => pathMatcher.`match`(pathPattern, entry.getName))
      .map(entry => entryUrl(entry))
      .toSeq
  }

  override lazy val name: String = {
    pluginVersionProperties match {
      case Some(props) => props.getProperty("plugin")
      case None => file.getName
    }
  }

  override def version: String = {
    pluginVersionProperties match {
      case Some(props) => props.getProperty("version")
      case None => ""
    }
  }

  private def entryUrl(entry: ZipEntry): URL = {
    // JAR protocol works for all zip based archives
    toJarURL(file.getAbsolutePath, entry.getName)
  }
}
