package com.xebialabs.xlrelease.plugin

import org.springframework.core.io.UrlResource
import org.springframework.core.io.support.PropertiesLoaderUtils

import java.net.URL
import java.util.Properties
import scala.util.Try

trait Plugin {
  def getResources(name: String): Seq[URL]

  def close(): Unit

  def find(pathPattern: String): Seq[URL]

  def name(): String

  def version(): String

  protected lazy val pluginVersionProperties: Option[Properties] = {
    Try {
      val urls = this.getResources("plugin-version.properties")
      val url = urls(0)
      // loadProperties closes input stream (should not be required to close a plugin)
      PropertiesLoaderUtils.loadProperties(new UrlResource(url))
    }.toOption
  }
}
