package com.xebialabs.xlrelease.booter.spring

import com.xebialabs.plugin.manager.repository.sql.SqlPluginRepository
import com.xebialabs.plugin.manager.validator.TypeSystemValidator
import com.xebialabs.xlrelease.booter.{XlrBooter, XlrPluginEventHandler}
import com.xebialabs.xlrelease.events.EventBus
import com.xebialabs.xlrelease.plugin.manager.validator.{JarPluginValidator, TypeChangeDetector, TypeChangeValidator, XlrTypeSystemValidator, ZipPluginValidator, ZipTypeChangeValidator}
import org.springframework.context.annotation.{Bean, Configuration}

import java.nio.file.Paths

@Configuration
class XlrBooterConfiguration(eventBus: EventBus,
                             pluginRepository: SqlPluginRepository,
                             xlrBooter: XlrBooter
                            ) {
  @Bean
  def typeChangeDetector: TypeChangeDetector = TypeChangeDetector

  @Bean
  def zipTypeChangeValidator: TypeChangeValidator = new ZipTypeChangeValidator()


  @Bean
  def xlrTypeSystemValidator(): TypeSystemValidator = {
    new XlrTypeSystemValidator(Array(zipPluginValidator, jarPluginValidator))
  }

  @Bean
  def zipPluginValidator: ZipPluginValidator = {
    new ZipPluginValidator(xlrBooter, typeChangeDetector, zipTypeChangeValidator)
  }

  @Bean
  def jarPluginValidator: JarPluginValidator = {
    new JarPluginValidator()
  }

  @Bean
  def xlrPluginEventHandler(): XlrPluginEventHandler = {
    val pluginsDir = Paths.get("plugins")
    val eventHandler = new XlrPluginEventHandler(eventBus, pluginsDir, pluginRepository, xlrBooter)
    eventBus.register(eventHandler)
    eventHandler
  }

}
