package com.xebialabs.xlrelease.plugin

import grizzled.slf4j.Logging
import org.springframework.util.AntPathMatcher

import java.io.File
import java.net.URL
import java.util.jar.JarFile
import scala.jdk.CollectionConverters._

case class JarPlugin(file: File) extends JarBasedPlugin with Logging {
  val jarFile = new JarFile(file)
  // make sure that plugin name is initialized otherwise it will not be removed in XlrPluginClassLoader.reload
  // and then "duplicate type" verification error will happen and it will not be easy to figure out why
  name

  override def getResources(name: String): Seq[URL] = {
    Option(jarFile.getEntry(name)).map(e => Seq(toJarURL(file.getAbsolutePath, e.getName))).getOrElse(Seq())
  }

  override def close(): Unit = jarFile.close()

  override def find(pathPattern: String): Seq[URL] = {
    val pathMatcher = new AntPathMatcher()
    val foundEntries = for {
      entry <- jarFile.entries().asScala
      if pathMatcher.`match`(pathPattern, entry.getName)
    } yield toJarURL(file.getAbsolutePath, entry.getName)
    foundEntries.toSeq
  }

  override lazy val name: String = {
    pluginVersionProperties match {
      case Some(props) => props.getProperty("plugin")
      case None => file.getName
    }
  }

  override def version: String = {
    pluginVersionProperties match {
      case Some(props) => props.getProperty("version")
      case None => "0.0.0"
    }
  }
}
