package com.xebialabs.xlrelease.booter

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry
import com.xebialabs.xlplatform.synthetic.TypeSpecification
import com.xebialabs.xlplatform.synthetic.xml.SyntheticXmlDocument
import com.xebialabs.xlplatform.synthetic.yaml.TypeDefinitionYamlDocument
import com.xebialabs.xlrelease.plugin.classloading.XlrPluginClassLoader

/**
 * Finds type-definitions.xml and type-definitions.yaml files that are inside PLUGINS.
 * It will NOT find ALL resources contributed by runtime dependencies (jars/zips we put into lib folder or add as gradle dependency).
 * (i.e. types that end up accessible because of application classloader will not be found by this implementation).
 *
 * IMPORTANT: It has to use findResources and not getResources method to find resources
 * because getResources method calls parent classloader and it will find extra files.
 */
class PluginClassLoaderTypeSpecificationRepository(xlrPluginClassLoader: XlrPluginClassLoader)
  extends TypeSpecificationRepository {

  import scala.jdk.CollectionConverters._

  override def find(registry: IDescriptorRegistry): List[TypeSpecification] = {
    val xmlSpecs = xlrPluginClassLoader.findResources("type-definitions.xml").asScala
      .flatMap { url =>
        val syntheticXml = SyntheticXmlDocument.read(url)
        val xmlTypeSpecifications = syntheticXml.getTypes.asScala
        xmlTypeSpecifications.toSeq
      }.toList
    val yamlSpecs = xlrPluginClassLoader.findResources("type-definitions.yaml").asScala
      .flatMap { url =>
        val syntheticYaml = TypeDefinitionYamlDocument.read(url)
        val yamlTypeSpecifications = syntheticYaml.getTypes.asScala
        yamlTypeSpecifications.toSeq
      }.toList

    xmlSpecs ++ yamlSpecs
  }

}
