package com.xebialabs.xlrelease.support.config

import com.typesafe.config.Config

import java.util.Properties
import scala.concurrent.duration.Duration
import scala.jdk.CollectionConverters._
import scala.jdk.DurationConverters._

object TypesafeConfigExt {
  implicit class ExtendedConfig(config: Config) {
    def getOptionalConfig(configName: String): Option[Config] = if (config.hasPath(configName)) Some(config.getConfig(configName)) else None

    def getOptionalString(path: String): Option[String] = if (config.hasPath(path)) Some(config.getString(path)) else None

    def getOptionalInt(path: String): Option[Integer] = if (config.hasPath(path)) Some(config.getInt(path)) else None

    def getOptionalLong(path: String): Option[Long] = if (config.hasPath(path)) Some(config.getLong(path)) else None

    def getOptionalBoolean(path: String): Option[Boolean] = if (config.hasPath(path)) Some(config.getBoolean(path)) else None

    def getOptionalDuration(path: String): Option[Duration] = if (config.hasPath(path)) Some(config.getDuration(path).toScala) else None

    def getInt(path: String, default: Int): Int = if (config.hasPath(path)) config.getInt(path) else default

    def getString(path: String, default: String): String = if (config.hasPath(path)) config.getString(path) else default

    def getBoolean(path: String, default: Boolean): Boolean = if (config.hasPath(path)) config.getBoolean(path) else default

    def toProperties: Properties = {
      val props = new Properties()
      config.entrySet().stream().forEach(entry => props.put(entry.getKey, entry.getValue.unwrapped()))
      props
    }

    def toMap: Map[String, String] = {
      config.entrySet().asScala.map(e => e.getKey -> e.getValue.unwrapped().toString).toMap
    }
  }

}
