/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SensitiveValueScrubber {
    private static final SensitiveValueScrubber DISABLED_INSTANCE = new SensitiveValueScrubber();
    private final String[] scrubValues;
    private final String[] replacementValue;
    private final String toStringValue;

    @VisibleForTesting
    public static SensitiveValueScrubber disabled() {
        return DISABLED_INSTANCE;
    }

    private SensitiveValueScrubber() {
        this.scrubValues = new String[0];
        this.replacementValue = new String[0];
        this.toStringValue = "";
    }

    public SensitiveValueScrubber(Set<String> variablesUsed, Map<String, String> variableMap) {
        HashSet<String> resolvedValues = new HashSet<String>();
        for (String variableName : variablesUsed) {
            String variableValue = variableMap.get(variableName);
            if (variableValue == null) continue;
            resolvedValues.add(variableValue);
        }
        this.scrubValues = resolvedValues.toArray(new String[0]);
        this.replacementValue = new String[this.scrubValues.length];
        for (int i = 0; i < this.scrubValues.length; ++i) {
            this.replacementValue[i] = "******";
        }
        this.toStringValue = variablesUsed.toString();
    }

    public String scrubValues(String original) {
        if (this.scrubValues.length == 0 || original.isEmpty()) {
            return original;
        }
        return StringUtils.replaceEachRepeatedly((String)original, (String[])this.scrubValues, (String[])this.replacementValue);
    }

    public String toString() {
        return "SensitiveValuesScrubber(" + this.toStringValue + ")";
    }
}

