/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.LazyConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.utils.MessageLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiHelper {
    private static final Logger logger = LoggerFactory.getLogger(CiHelper.class);
    public static final Function<ConfigurationItem, String> TO_ID = ConfigurationItem::getId;

    public static List<ConfigurationItem> getNestedCis(Collection<? extends ConfigurationItem> cis) {
        LinkedHashSet<ConfigurationItem> visitedItems = new LinkedHashSet<ConfigurationItem>();
        for (ConfigurationItem configurationItem : cis) {
            visitedItems.addAll(CiHelper.getNestedCis(configurationItem));
        }
        return new ArrayList<ConfigurationItem>(visitedItems);
    }

    public static List<ConfigurationItem> getNestedCis(ConfigurationItem ci) {
        MessageLogger traceLog = new MessageLogger();
        LinkedHashSet<ConfigurationItem> visitedItems = new LinkedHashSet<ConfigurationItem>();
        CiHelper.getNestedCis(traceLog, visitedItems, ci);
        return new ArrayList<ConfigurationItem>(visitedItems);
    }

    private static void getNestedCis(MessageLogger traceLog, Set<ConfigurationItem> alreadyVisitedItems, ConfigurationItem ci) {
        if (!alreadyVisitedItems.contains(ci)) {
            if (logger.isTraceEnabled()) {
                traceLog.log(String.format("Adding ci %s[%s]", ci.getType(), ci));
            }
            alreadyVisitedItems.add(ci);
            List<ConfigurationItem> children = CiHelper.getChildren(traceLog, ci);
            for (ConfigurationItem child : children) {
                traceLog.increaseDepth();
                CiHelper.getNestedCis(traceLog, alreadyVisitedItems, child);
                traceLog.decreaseDepth();
            }
        } else {
            logger.trace("Item {}[{}] was already visited. Circular reference detected. Log: \n {}", new Object[]{ci.getType(), ci, traceLog.msg()});
        }
    }

    public static void eraseTokens(ConfigurationItem ci) {
        CiHelper.getNestedCis(ci).forEach(bci -> {
            if (bci instanceof BaseConfigurationItem) {
                ((BaseConfigurationItem)bci).set$token(null);
            }
        });
    }

    public static void rewriteWithNewId(ConfigurationItem ci, String newId) {
        String rewrittenId;
        String oldId = ci.getId();
        String oldIdPattern = String.format("%s(?=/|$)", oldId);
        CiHelper.eraseTokens(ci);
        for (ConfigurationItem nestedCi : CiHelper.getNestedCis(ci)) {
            if (nestedCi.getId() == null || !nestedCi.getId().startsWith(oldId)) continue;
            rewrittenId = nestedCi.getId().replaceFirst(oldIdPattern, newId);
            nestedCi.setId(rewrittenId);
        }
        for (ConfigurationItem referencedCi : CiHelper.getExternalReferences(ci)) {
            if (referencedCi.getId() == null || !referencedCi.getId().startsWith(oldId)) continue;
            rewrittenId = referencedCi.getId().replaceFirst(oldIdPattern, newId);
            referencedCi.setId(rewrittenId);
        }
    }

    public static Set<ConfigurationItem> getExternalReferences(ConfigurationItem parentCi) {
        HashSet<ConfigurationItem> references = new HashSet<ConfigurationItem>();
        for (ConfigurationItem ci : CiHelper.getNestedCis(parentCi)) {
            for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
                Object value;
                if (property.isAsContainment() || (value = property.get(ci)) == null) continue;
                PropertyKind kind = property.getKind();
                if (kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
                    references.addAll((Collection)value);
                }
                if (kind != PropertyKind.CI || CiHelper.isChildViaOneOfChildProperties((ConfigurationItem)value, ci)) continue;
                references.add((ConfigurationItem)value);
            }
        }
        return references;
    }

    public static boolean isLazyConfigurationItem(ConfigurationItem possibleChild) {
        return possibleChild instanceof LazyConfigurationItem;
    }

    public static void stripChildrenCis(ConfigurationItem ci) {
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyKind kind = property.getKind();
            if (kind != PropertyKind.SET_OF_CI && kind != PropertyKind.LIST_OF_CI) continue;
            Collection references = (Collection)property.get(ci);
            references.clear();
        }
    }

    public static void removeCisWithId(Collection<? extends ConfigurationItem> fromCis, String idToRemove) {
        fromCis.removeIf(ci -> idToRemove.equals(ci.getId()));
    }

    public static void fixUpInternalReferences(ConfigurationItem parent) {
        MessageLogger traceLog = new MessageLogger();
        CiHelper.fixUpInternalReferences(traceLog, parent);
    }

    private static void fixUpInternalReferences(MessageLogger traceLog, ConfigurationItem parent) {
        List<ConfigurationItem> children = CiHelper.getChildren(traceLog, parent);
        for (ConfigurationItem child : children) {
            for (PropertyDescriptor property : child.getType().getDescriptor().getPropertyDescriptors()) {
                PropertyKind kind = property.getKind();
                if (kind != PropertyKind.CI || !property.isAsContainment() || property.get(child) != null) continue;
                property.set(child, (Object)parent);
            }
            CiHelper.fixUpInternalReferences(traceLog, child);
        }
    }

    private static List<ConfigurationItem> getChildren(MessageLogger traceLog, ConfigurationItem ci) {
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        if (ci == null) {
            return children;
        }
        for (PropertyDescriptor property : ci.getType().getDescriptor().getPropertyDescriptors()) {
            ConfigurationItem child2;
            PropertyKind kind = property.getKind();
            if (kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
                Collection<ConfigurationItem> childrenForProperty = CiHelper.getChildrenForProperty(ci, property);
                if (logger.isTraceEnabled()) {
                    childrenForProperty.forEach(child -> traceLog.log(String.format("- found child of %s.%s[%s] => %s[%s] ", ci.getType(), property.getName(), ci, child.getType(), child)));
                }
                children.addAll(childrenForProperty);
            }
            if (kind != PropertyKind.CI || (child2 = (ConfigurationItem)property.get(ci)) == null || !CiHelper.isChildViaOneToOneRelationship(child2, ci, property) && !CiHelper.isNestedProperty(child2, ci, property)) continue;
            if (logger.isTraceEnabled()) {
                traceLog.log(String.format("- found child of %s.%s[%s] => %s[%s] ", ci.getType(), property.getName(), ci, child2.getType(), child2));
            }
            children.add(child2);
        }
        return children;
    }

    private static boolean isNestedProperty(ConfigurationItem child, ConfigurationItem ci, PropertyDescriptor property) {
        ConfigurationItem value = (ConfigurationItem)property.get(ci);
        return child.equals(value) && property.isNested();
    }

    private static Collection<ConfigurationItem> getChildrenForProperty(ConfigurationItem parent, PropertyDescriptor property) {
        Collection references = (Collection)property.get(parent);
        if (references == null) {
            return new ArrayList<ConfigurationItem>();
        }
        Collection nonNullReferences = references.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (property.isAsContainment()) {
            return nonNullReferences;
        }
        return nonNullReferences.stream().filter(ci -> CiHelper.isChildViaOneOfChildProperties(ci, parent)).collect(Collectors.toList());
    }

    public static boolean isChildViaOneOfChildProperties(ConfigurationItem possibleChild, ConfigurationItem parent) {
        if (CiHelper.isLazyConfigurationItem(possibleChild)) {
            return false;
        }
        for (PropertyDescriptor property : possibleChild.getType().getDescriptor().getPropertyDescriptors()) {
            PropertyKind kind = property.getKind();
            if (kind != PropertyKind.CI || !property.isAsContainment() || !parent.equals(property.get(possibleChild))) continue;
            return true;
        }
        return false;
    }

    private static boolean isChildViaOneToOneRelationship(ConfigurationItem possibleChild, ConfigurationItem parent, PropertyDescriptor parentProperty) {
        boolean parentPropertyIsNotAContainment;
        boolean bl = parentPropertyIsNotAContainment = !parentProperty.isAsContainment();
        if (parentPropertyIsNotAContainment) {
            for (PropertyDescriptor childProperty : possibleChild.getType().getDescriptor().getPropertyDescriptors()) {
                PropertyKind kind = childProperty.getKind();
                if (kind != PropertyKind.CI || !childProperty.isAsContainment() || possibleChild instanceof LazyConfigurationItem && !((LazyConfigurationItem)possibleChild).isInitialized()) continue;
                Object possibleParentReference = childProperty.get(possibleChild);
                if (parent.equals(possibleParentReference)) {
                    return true;
                }
                if (possibleParentReference != null || !possibleChild.getType().instanceOf(parentProperty.getReferencedType()) || !parent.getType().instanceOf(childProperty.getReferencedType())) continue;
                return true;
            }
        }
        return false;
    }

    public static ConfigurationItem forFields(ConfigurationItem ci, PropertyFilter filter, PropertyAction action) {
        ci.getType().getDescriptor().getPropertyDescriptors().stream().filter(filter).forEach(pd -> action.execute(ci, (PropertyDescriptor)pd));
        return ci;
    }

    @FunctionalInterface
    public static interface PropertyAction {
        public void execute(ConfigurationItem var1, PropertyDescriptor var2);
    }

    @FunctionalInterface
    public static interface PropertyFilter
    extends Predicate<PropertyDescriptor> {
    }
}

