package com.xebialabs.xlrelease.security;

import java.util.*;
import java.util.stream.Collectors;

import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;
import static com.xebialabs.deployit.security.permission.PermissionHandler.Level.BOTH;
import static com.xebialabs.deployit.security.permission.PermissionHandler.Level.CI;
import static com.xebialabs.deployit.security.permission.PermissionHandler.Level.GLOBAL;

public class XLReleasePermissions extends PlatformPermissions {

    public static final Permission CREATE_TEMPLATE = Permission.definePermission("template#create", GLOBAL);
    public static final Permission CREATE_RELEASE = Permission.definePermission("release#create", GLOBAL);
    public static final Permission VIEW_REPORTS = Permission.definePermission("reports#view", GLOBAL);
    public static final Permission AUDIT_ALL = Permission.definePermission("all#audit", GLOBAL);
    public static final Permission CREATE_DASHBOARD = Permission.definePermission("dashboard#create", GLOBAL);
    public static final Permission EDIT_GLOBAL_VARIABLES = Permission.definePermission("global_variables#edit", GLOBAL);
    public static final Permission CREATE_TOP_LEVEL_FOLDER = Permission.definePermission("folder#create_top_level", GLOBAL);
    public static final Permission EDIT_GLOBAL_BLACKOUT = Permission.definePermission("global_calendar#edit_blackout", GLOBAL);
    public static final Permission EDIT_RISK_PROFILE = Permission.definePermission("risk_profile#edit", GLOBAL);
    public static final Permission EDIT_ENVIRONMENT = Permission.definePermission("environment#edit", GLOBAL);
    public static final Permission VIEW_ENVIRONMENT = Permission.definePermission("environment#view", GLOBAL);
    public static final Permission EDIT_APPLICATION = Permission.definePermission("application#edit", GLOBAL);
    public static final Permission VIEW_APPLICATION = Permission.definePermission("application#view", GLOBAL);
    public static final Permission EDIT_RESERVATION = Permission.definePermission("reservation#edit", GLOBAL);

    public static final Permission RUNNER_REGISTRATION = Permission.definePermission("runner#registration", GLOBAL);

    public static final Permission CREATE_RELEASE_FROM_TEMPLATE = Permission.definePermission("template#create_release", CI, APPLICATIONS, true);
    public static final Permission CREATE_RELEASE_IN_ANOTHER_FOLDER = Permission.definePermission("template#create_release_other_folder", CI, APPLICATIONS, true);
    public static final Permission VIEW_TEMPLATE = Permission.definePermission("template#view", CI, APPLICATIONS, true);
    public static final Permission EDIT_TEMPLATE = Permission.definePermission("template#edit", CI, APPLICATIONS, true);
    public static final Permission EDIT_TEMPLATE_SECURITY = Permission.definePermission("template#edit_security", CI, APPLICATIONS, true);

    /**
     * See REL-9522
     *
     * @deprecated Use trigger#edit_trigger instead.
     */
    @Deprecated
    public static final Permission EDIT_TEMPLATE_TRIGGERS = Permission.definePermission("template#edit_triggers", CI, APPLICATIONS, true);
    public static final Permission VIEW_RELEASE = Permission.definePermission("release#view", CI, APPLICATIONS, true);
    public static final Permission EDIT_RELEASE = Permission.definePermission("release#edit", CI, APPLICATIONS, true);
    public static final Permission EDIT_RELEASE_SECURITY = Permission.definePermission("release#edit_security", CI, APPLICATIONS, true);
    public static final Permission START_RELEASE = Permission.definePermission("release#start", CI, APPLICATIONS, true);
    public static final Permission ABORT_RELEASE = Permission.definePermission("release#abort", CI, APPLICATIONS, true);
    public static final Permission EDIT_RELEASE_TASK = Permission.definePermission("release#edit_task", CI, APPLICATIONS, true);
    public static final Permission EDIT_RELEASE_TASK_SCRIPT = Permission.definePermission("release#edit_task_script", CI, APPLICATIONS, true);
    public static final Permission EDIT_RELEASE_TASK_CONFIGURATION = Permission.definePermission("release#edit_task_input_output_properties", CI, APPLICATIONS, true);
    public static final Permission EDIT_RELEASE_TASK_CONFIGURATION_FACET = Permission.definePermission("release#edit_task_configuration_facet", CI, APPLICATIONS, true);
    public static final Permission REASSIGN_RELEASE_TASK = Permission.definePermission("release#reassign_task", CI, APPLICATIONS, true);
    public static final Permission EDIT_BLACKOUT = Permission.definePermission("release#edit_blackout", CI, APPLICATIONS, true);
    public static final Permission TASK_TRANSITION = Permission.definePermission("release#task_transition", CI, APPLICATIONS, true);
    public static final Permission ADVANCE_TASK_TRANSITION = Permission.definePermission("release#advance_task_transition", CI, APPLICATIONS, true);
    public static final Permission EDIT_TASK_TAGS = Permission.definePermission("release#edit_task_tags", CI, APPLICATIONS, true);
    public static final Permission EDIT_RELEASE_TASK_ATTACHMENT = Permission.definePermission("release#edit_task_attachments", CI, APPLICATIONS, true);
    public static final Permission EDIT_TASK_DESCRIPTION = Permission.definePermission("release#edit_task_description", CI, APPLICATIONS, true);
    public static final Permission EDIT_TASK_DATES = Permission.definePermission("release#edit_task_dates", CI, APPLICATIONS, true);
    public static final Permission EDIT_TASK_FLAG = Permission.definePermission("release#edit_task_flag", CI, APPLICATIONS, true);
    public static final Permission RESTART_PHASE = Permission.definePermission("release#restart_phase", CI, APPLICATIONS, true);

    public static final Permission VIEW_FOLDER = Permission.definePermission("folder#view", CI, APPLICATIONS, true);
    public static final Permission EDIT_FOLDER = Permission.definePermission("folder#edit", CI, APPLICATIONS, true);
    public static final Permission EDIT_FOLDER_SECURITY = Permission.definePermission("folder#edit_security", CI, APPLICATIONS, true);
    public static final Permission EDIT_FOLDER_TEAMS = Permission.definePermission("folder#edit_teams", CI, APPLICATIONS, true);
    public static final Permission EDIT_FOLDER_NOTIFICATIONS = Permission.definePermission("folder#edit_notifications", CI, APPLICATIONS, true);
    public static final Permission EDIT_FOLDER_CONFIGURATION = Permission.definePermission("folder#edit_configuration", CI, APPLICATIONS, true);
    public static final Permission EDIT_FOLDER_VARIABLES = Permission.definePermission("folder#edit_variables", CI, APPLICATIONS, true);
    public static final Permission VIEW_FOLDER_VERSIONS = Permission.definePermission("folder#view_versions", CI, APPLICATIONS, true);
    public static final Permission EDIT_FOLDER_VERSIONS = Permission.definePermission("folder#edit_versions", CI, APPLICATIONS, true);
    public static final Permission APPLY_FOLDER_CHANGES = Permission.definePermission("folder#apply_changes", CI, APPLICATIONS, true);
    public static final Permission GENERATE_FOLDER_CONFIGURATION = Permission.definePermission("folder#generate_configuration", CI, APPLICATIONS, true);

    public static final Permission VIEW_RELEASE_DELIVERY = Permission.definePermission("delivery#view", CI, APPLICATIONS, true);
    public static final Permission EDIT_RELEASE_DELIVERY = Permission.definePermission("delivery#edit", CI, APPLICATIONS, true);
    public static final Permission EDIT_DELIVERY_TRACKED_ITEM = Permission.definePermission("delivery#edit_tracked_item", CI, APPLICATIONS, true);

    public static final Permission VIEW_DELIVERY_PATTERN = Permission.definePermission("delivery_pattern#view", CI, APPLICATIONS, true);
    public static final Permission EDIT_DELIVERY_PATTERN = Permission.definePermission("delivery_pattern#edit", CI, APPLICATIONS, true);

    public static final Permission VIEW_RELEASE_GROUP = Permission.definePermission("group#view", CI, APPLICATIONS, true);
    public static final Permission EDIT_RELEASE_GROUP = Permission.definePermission("group#edit", CI, APPLICATIONS, true);

    public static final Permission LOCK_RELEASE_TASK = Permission.definePermission("release#lock_task", CI, APPLICATIONS, true);
    public static final Permission LOCK_TEMPLATE_TASK = Permission.definePermission("template#lock_task", CI, APPLICATIONS, true);

    public static final Permission VIEW_DASHBOARD = Permission.definePermission("dashboard#view", CI, APPLICATIONS, true);
    public static final Permission EDIT_DASHBOARD = Permission.definePermission("dashboard#edit", CI, APPLICATIONS, true);

    public static final Permission VIEW_TRIGGER =
            Permission.definePermission("trigger#view_trigger", CI, APPLICATIONS, true);
    public static final Permission EDIT_TRIGGER =
            Permission.definePermission("trigger#edit_trigger", CI, APPLICATIONS, true);

    public static final Permission EDIT_RELEASE_FAILURE_HANDLER =
            Permission.definePermission("release#edit_failure_handler", CI, APPLICATIONS, true);
    public static final Permission EDIT_TEMPLATE_FAILURE_HANDLER =
            Permission.definePermission("template#edit_failure_handler", CI, APPLICATIONS, true);

    public static final Permission EDIT_RELEASE_PRECONDITION =
            Permission.definePermission("release#edit_precondition", CI, APPLICATIONS, true);
    public static final Permission EDIT_TEMPLATE_PRECONDITION =
            Permission.definePermission("template#edit_precondition", CI, APPLICATIONS, true);

    public static final Permission VIEW_WORKFLOW_EXECUTION =
            Permission.definePermission("workflow#view_execution", CI, APPLICATIONS, true);
    public static final Permission START_WORKFLOW_EXECUTION =
            Permission.definePermission("workflow#start_execution", CI, APPLICATIONS, true);
    public static final Permission ABORT_WORKFLOW_EXECUTION =
            Permission.definePermission("workflow#abort_execution", CI, APPLICATIONS, true);

    public static final Permission VIEW_APP_PIPELINES =
            Permission.definePermission("app_pipelines#view", CI, APPLICATIONS, true);
    public static final Permission EDIT_APP_PIPELINES =
            Permission.definePermission("app_pipelines#edit", CI, APPLICATIONS, true);

    // Used for creating a team with no permissions
    public static final Permission DUMMY = Permission.definePermission("dummy", CI);

    public static final String ADMIN_USERNAME = "admin";

    public static final String AUTHENTICATED_USER = "authenticated-user";

    public static final String GLOBAL_AUTHENTICATED_USERS_ROLE = "Authenticated Users";

    public static final Map<Permission, Integer> GLOBAL_PERMISSION_PRESENTATION_ORDER = makeGlobalPermissionPresentationOrder();

    public static final Map<Permission, Integer> FOLDER_PERMISSION_PRESENTATION_ORDER = makeFolderPermissionPresentationOrder();

    public static void init() {
        // Dummy method that can be called to ensure that the class is loaded and the permissions are registered
    }

    public static void removePermission(Permission permission) {
        Permission.unregisterPermission(permission);
    }

    public static List<String> getGlobalPermissions() {
        List<String> permissions = new ArrayList();

        for (Permission permission : Permission.getAll()) {
            if ((permission.getLevel() == BOTH || permission.getLevel() == GLOBAL)) {
                permissions.add(permission.getPermissionName());
            }
        }

        return permissions;
    }

    public static List<String> getTemplatePermissions() {
        return getLocalPermissions("template", "release");
    }

    public static List<String> getReleasePermissions() {
        return getLocalPermissions("release");
    }

    public static List<String> getTriggerPermissions() {
        return getLocalPermissions("trigger");
    }

    public static List<String> getWorkflowExecutionPermissions() {
        return getLocalPermissions("workflow");
    }

    public static List<String> getTemplateOnlyPermissions() {
        return getLocalPermissions("template");
    }

    public static List<String> getFolderPermissions() {
        return getLocalPermissions("folder");
    }

    public static List<String> getReleaseGroupPermissions() {
        return getLocalPermissions("group");
    }

    public static List<String> getDeliveryPermissions() {
        return getLocalPermissions("delivery");
    }

    public static List<String> getDashboardPermissions() {
        return getLocalPermissions("dashboard");
    }

    public static List<String> getAppPipelinesPermissions() {
        return getLocalPermissions("app_pipelines");
    }

    public static boolean isAdmin(String username) {
        return ADMIN_USERNAME.equalsIgnoreCase(username);
    }

    private static List<String> getLocalPermissions(String... prefixes) {
        return Permission.getAll().stream()
                .filter(permission -> permission.getLevel() == CI && permission.getRoot() == APPLICATIONS)
                .filter(permission -> Arrays.stream(prefixes).anyMatch(prefix -> permission.getPermissionName().startsWith(prefix)))
                .map(Permission::getPermissionName)
                .collect(Collectors.toList());
    }

    private static boolean isTemplatePermission(final Permission permission) {
        return permission.getPermissionName().startsWith("template");
    }

    private static Map<Permission, Integer> makeGlobalPermissionPresentationOrder() {
        Map<Permission, Integer> result = new HashMap<>();

        result.put(PlatformPermissions.ADMIN, result.size());
        result.put(PlatformPermissions.LOGIN, result.size());
        result.put(PlatformPermissions.EDIT_SECURITY, result.size());
        result.put(CREATE_TEMPLATE, result.size());
        result.put(CREATE_RELEASE, result.size());
        result.put(PlatformPermissions.REPORT_VIEW, result.size());
        result.put(VIEW_REPORTS, result.size());
        result.put(AUDIT_ALL, result.size());
        result.put(CREATE_DASHBOARD, result.size());
        result.put(EDIT_GLOBAL_VARIABLES, result.size());
        result.put(CREATE_TOP_LEVEL_FOLDER, result.size());
        result.put(EDIT_GLOBAL_BLACKOUT, result.size());
        result.put(EDIT_RISK_PROFILE, result.size());
        result.put(VIEW_ENVIRONMENT, result.size());
        result.put(EDIT_ENVIRONMENT, result.size());
        result.put(VIEW_APPLICATION, result.size());
        result.put(EDIT_APPLICATION, result.size());
        result.put(EDIT_RESERVATION, result.size());

        return Collections.unmodifiableMap(result);
    }

    private static Map<Permission, Integer> makeFolderPermissionPresentationOrder() {
        Map<Permission, Integer> result = new HashMap<>();

        result.put(VIEW_FOLDER, result.size());
        result.put(EDIT_FOLDER, result.size());
        result.put(EDIT_FOLDER_VARIABLES, result.size());
        result.put(EDIT_FOLDER_SECURITY, result.size());
        result.put(EDIT_FOLDER_TEAMS, result.size());
        result.put(EDIT_FOLDER_NOTIFICATIONS, result.size());

        result.put(VIEW_TEMPLATE, result.size());
        result.put(EDIT_TEMPLATE, result.size());
        result.put(LOCK_TEMPLATE_TASK, result.size());
        result.put(EDIT_TEMPLATE_PRECONDITION, result.size());
        result.put(EDIT_TEMPLATE_FAILURE_HANDLER, result.size());

        result.put(VIEW_WORKFLOW_EXECUTION, result.size());
        result.put(START_WORKFLOW_EXECUTION, result.size());
        result.put(ABORT_WORKFLOW_EXECUTION, result.size());

        result.put(VIEW_APP_PIPELINES, result.size());
        result.put(EDIT_APP_PIPELINES, result.size());

        result.put(VIEW_RELEASE, result.size());
        result.put(EDIT_RELEASE, result.size());
        result.put(CREATE_RELEASE_FROM_TEMPLATE, result.size());
        result.put(START_RELEASE, result.size());
        result.put(ABORT_RELEASE, result.size());
        result.put(RESTART_PHASE, result.size());

        result.put(LOCK_RELEASE_TASK, result.size());
        result.put(EDIT_RELEASE_TASK, result.size());
        result.put(TASK_TRANSITION, result.size());
        result.put(ADVANCE_TASK_TRANSITION, result.size());
        result.put(REASSIGN_RELEASE_TASK, result.size());
        result.put(EDIT_TASK_DESCRIPTION, result.size());
        result.put(EDIT_RELEASE_TASK_CONFIGURATION, result.size());
        result.put(EDIT_RELEASE_TASK_SCRIPT, result.size());
        result.put(EDIT_TASK_FLAG, result.size());
        result.put(EDIT_TASK_TAGS, result.size());
        result.put(EDIT_TASK_DATES, result.size());
        result.put(EDIT_BLACKOUT, result.size());
        result.put(EDIT_RELEASE_PRECONDITION, result.size());
        result.put(EDIT_RELEASE_FAILURE_HANDLER, result.size());
        result.put(EDIT_RELEASE_TASK_CONFIGURATION_FACET, result.size());
        result.put(EDIT_RELEASE_TASK_ATTACHMENT, result.size());

        result.put(VIEW_DELIVERY_PATTERN, result.size());
        result.put(EDIT_DELIVERY_PATTERN, result.size());

        result.put(VIEW_RELEASE_DELIVERY, result.size());
        result.put(EDIT_RELEASE_DELIVERY, result.size());
        result.put(EDIT_DELIVERY_TRACKED_ITEM, result.size());

        result.put(VIEW_DASHBOARD, result.size());
        result.put(EDIT_DASHBOARD, result.size());

        result.put(VIEW_RELEASE_GROUP, result.size());
        result.put(EDIT_RELEASE_GROUP, result.size());

        result.put(EDIT_FOLDER_VERSIONS, result.size());
        result.put(VIEW_FOLDER_VERSIONS, result.size());

        result.put(APPLY_FOLDER_CHANGES, result.size());
        result.put(GENERATE_FOLDER_CONFIGURATION, result.size());

        result.put(EDIT_FOLDER_CONFIGURATION, result.size());

        result.put(VIEW_TRIGGER, result.size());
        result.put(EDIT_TRIGGER, result.size());

        return Collections.unmodifiableMap(result);
    }

}
