package com.xebialabs.xlrelease.utils

import java.util.function.BiFunction
import scala.collection.mutable

class FixedSizeMap[A, B](_entries: mutable.Map[A, B], private var _size: Int) {

  def entries: Map[A, B] = _entries.toMap

  def keySet: Set[A] = _entries.keySet.toSet

  def values: Seq[B] = _entries.values.toSeq

  def isEmpty: Boolean = _entries.isEmpty

  def nonEmpty: Boolean = _entries.nonEmpty

  def size: Int =
    _entries.size

  def maxSize: Int =
    _size

  def get(key: A): Option[B] =
    _entries.get(key)

  def add(entry: (A, B)): Boolean = synchronized {
    (_entries.size < _size) && {
      _entries += entry
      true
    }
  }

  def update(entry: (A, B)): Boolean = synchronized {
    _entries.get(entry._1).exists { _ =>
      _entries += entry
      true
    }
  }

  def compute(entry: (A, B), mergeFn: BiFunction[B, B, B]): Boolean = synchronized {
    _entries.get(entry._1).map { existing =>
      _entries += entry._1 -> mergeFn.apply(existing, entry._2)
      true
    } getOrElse {
      add(entry)
    }
  }

  def remove(key: A): Option[B] = synchronized {
    _entries.get(key).map { value =>
      _entries.remove(key)
      value
    }
  }

  def clear(): Unit = synchronized {
    _entries.clear()
  }

  def resize(newSize: Int): Boolean = synchronized {
    if (_entries.size <= newSize) {
      _size = newSize
      true
    } else {
      false
    }
  }

}

object FixedSizeMap {
  def empty[A, B](size: Int): FixedSizeMap[A, B] = new FixedSizeMap(mutable.Map.empty, size)
}
