package com.xebialabs.xlrelease.repository;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;
import static com.xebialabs.xlrelease.repository.Ids.CUSTOM_CONFIGURATION_ROOT;

public enum IdType {
    DOMAIN {
        private final String APPLICATIONS_ROOT = APPLICATIONS.getRootNodeName() + "/";

        @Override
        public String convertToInternalId(String viewId) {
            if (null != viewId) {
                return APPLICATIONS_ROOT + viewId.replace('-', '/');
            } else {
                throw new IllegalArgumentException("Empty View id");
            }
        }

        @Override
        public String convertToViewId(String internalId) {
            if (internalId != null) {
                String id = internalId.contains(APPLICATIONS_ROOT) ? internalId.substring(APPLICATIONS_ROOT.length()) : internalId;
                return id.replace('/', '-');
            } else {
                throw new IllegalArgumentException("Internal id is null");
            }
        }
    },
    CONFIGURATION {
        private final String CONFIGURATION_ROOT = CUSTOM_CONFIGURATION_ROOT + "/";

        @Override
        public String convertToInternalId(String viewId) {
            if (null != viewId) {
                return viewId.startsWith(CONFIGURATION_ROOT) ? viewId : CONFIGURATION_ROOT + viewId;
            } else {
                throw new IllegalArgumentException("Empty View id");
            }
        }

        @Override
        public String convertToViewId(String internalId) {
            if (internalId != null && internalId.startsWith(CONFIGURATION_ROOT)) {
                return internalId.substring(CONFIGURATION_ROOT.length());
            } else {
                throw new IllegalArgumentException("Invalid repository id : " + internalId);
            }
        }
    };


    public abstract String convertToInternalId(String viewId);

    public abstract String convertToViewId(String internalId);
}
