package com.xebialabs.xlrelease.utils

object ListUtils {
  implicit class ScalaListUpdateInPlace[A](val list: List[A]) extends AnyVal {
    def replace(findElem: A => Boolean, elem: A): List[A] = list.span(e => !findElem(e)) match {
      case (before, Nil) => before :+ elem
      case (before, _ :: after) => before ++ (elem :: after)
    }
  }
}
