/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.repository.Ids;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IdType {
    DOMAIN{
        private final String APPLICATIONS_ROOT = Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName() + "/";

        @Override
        public String convertToInternalId(String viewId) {
            if (null != viewId) {
                return this.APPLICATIONS_ROOT + viewId.replace('-', '/');
            }
            throw new IllegalArgumentException("Empty View id");
        }

        @Override
        public String convertToViewId(String internalId) {
            if (internalId != null) {
                String id = internalId.contains(this.APPLICATIONS_ROOT) ? internalId.substring(this.APPLICATIONS_ROOT.length()) : internalId;
                return id.replace('/', '-');
            }
            throw new IllegalArgumentException("Internal id is null");
        }
    }
    ,
    CONFIGURATION{
        private final String CONFIGURATION_ROOT = Ids.CUSTOM_CONFIGURATION_ROOT + "/";

        @Override
        public String convertToInternalId(String viewId) {
            if (null != viewId) {
                return viewId.startsWith(this.CONFIGURATION_ROOT) ? viewId : this.CONFIGURATION_ROOT + viewId;
            }
            throw new IllegalArgumentException("Empty View id");
        }

        @Override
        public String convertToViewId(String internalId) {
            if (internalId != null && internalId.startsWith(this.CONFIGURATION_ROOT)) {
                return internalId.substring(this.CONFIGURATION_ROOT.length());
            }
            throw new IllegalArgumentException("Invalid repository id : " + internalId);
        }
    };


    public abstract String convertToInternalId(String var1);

    public abstract String convertToViewId(String var1);
}

